package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/6/14
 * @description
 */
@Getter
@AllArgsConstructor
public enum DyfsEnum {
    DYFS_YBDY("1", "一般抵押"),
    DYFS_ZGEDY("2", "最高额抵押"),
    DYFS_YBDYSW("4", "一般抵押"),
    DYFS_ZGEDYSW("5", "最高额抵押");

    private String code;

    private String msg;

    public static String getMc(String code) {
        for (DyfsEnum xq : DyfsEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
