package cn.gtmap.hlw.core.dto.sqxx.tz;

import cn.gtmap.hlw.core.base.BasePage;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/11/16 10:11
 * @description PublicSqxxTzParamsDTO
 */
@Data
public class PublicSqxxTzParamsDTO extends BasePage {
    /**
     * 申请类型
     */
    private String sqlx;
    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 权利人名称
     */
    private String qlrmc;
    /**
     * 义务人名称
     */
    private String ywrmc;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 坐落
     */
    private String zl;
    /**
     * 开始时间：yyyy-mm-dd 00:00:00  gx_yy_sqxx.create_date
     */
    private String kssj;

    /**
     * 开始时间：yyyy-mm-dd 23:59:59  gx_yy_sqxx.create_date
     */
    private String jssj;
    /**
     * 导出状态
     */
    private String dczt;
    /**
     * 登陆人 此字段对应 gx_yy_sqxx.create_userid
     */
    private String userGuid;
    /**
     * 当前登陆人所属部门  此字段不作为查询条件，放在orgIdList作为查询条件
     */
    private String orgId;
    /**
     * 本部门及下属之部门OrgId; gx_yy_sqxx.create_org_id
     */
    private List<String> orgIdList;
    /**
     * 受理编号集合
     */
    private List<String> slbhList;
}
