package cn.gtmap.hlw.core.dto.sqxx.save;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/7 22:09
 * @description 附属设施信息
 */
@Data
public class FsssxxDTO implements Serializable {
    /**ID主键 */
    private String id;

    /**申请ID （与SQXX表关联）*/
    private String sqid;

    /**受理编号 （与SQXX表关联）*/
    private String slbh;

    /**不动产单元编号*/
    private String bdcdybh;

    /** 不动产单元号*/
    private String bdcdyh;

    /**不动产权证号*/
    private String bdcqzh;

    /** 项目id*/
    private String xmid;

    /**合同编号*/
    private String htbh;

    /**备案时间 YYYY-MM-DD*/
    private String basj;

    /**付款方式代码*/
    private String fkfsdm;

    /**交易价格（元）*/
    private String jyjg;

    /**合同坐落*/
    private String htzl;

    /**坐落（附属设施）*/
    private String zl;

    /**权利人（附属设施）*/
    private String qlr;

    /**是否查封 0:否  1:是*/
    private String sfcf;

    /**是否抵押 0:否  1:是*/
    private String sfdy;

    /**是否异议 0:否  1:是*/
    private String sfyy;

    /**是否预告 0:否  1:是*/
    private String sfyg;

    /**是否锁定 0:否  1:是*/
    private String sfsd;

    /**是否注销 0:否  1:是*/
    private String sfzx;

    /**房屋面积*/
    private Double fwmj;

    /**预告证明号）*/
    private String ygzmh;

    /**竣工时间(YYYY-MM-DD)*/
    private Date jgsj;

    /**所在层*/
    private String szc;

    /**
     * 总层数
     */
    private Double zcs;

    /**房屋类型(代码)*/
    private String fwlx;

    /**规划用途(代码)*/
    private String ghyt;

    /**规划用途(名称)*/
    @ZdTypeConfig(field = "ghyt", tableName = ZdTypeConstant.ZD_TYPE_GHYT, dmToMc = true)
    private String ghytmc;

    /**宗地用途(代码)*/
    private String zdyt;

    /**宗地使用结束期限(YYYY-MM-DD)*/
    private Date zdsyjsrq;

    /**宗地使用权类型(代码)*/
    private String zdsyqlx;

    /**房屋结构(代码)*/
    private String fwjg;

    /**房屋结构(名称)*/
    @ZdTypeConfig(field = "fwjg", tableName = ZdTypeConstant.ZD_TYPE_FWJG, dmToMc = true)
    private String fwjgmc;

    /**房屋性质(代码)*/
    private String fwxz;

    /**房屋性质(名称)*/
    @ZdTypeConfig(field = "fwxz", tableName = ZdTypeConstant.ZD_TYPE_FWXZ, dmToMc = true)
    private String fwxzmc;

    /**附属设施类型（1：附属设施；2：附属设施合同设施）*/
    private String fssslx;

    /**附属设施种类（放代码）*/
    private String fssszl;

    /**面积*/
    private Double mj;

}
