package cn.gtmap.hlw.core.dto.exchange.push;


import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/3/25
 * @description 物流信息
 */
@Data
public class PushWlxxDTO {
    /**  物流ID*/
    private String wlid;

    /**受理编号*/
    private String slbh;

    /**  领证方式代码*/
    private String lzfsdm;

    /**  领证方式名称*/
    private String lzfsmc;

    /**  收件人联系电话*/
    private String sjrlxdh;

    /**  收件人名称*/
    private String sjrmc;

    /**  收件人证件号*/
    private String sjrzjh;

    /**  收件人证件种类*/
    private String sjrzjzl;

    /**  收件人所在市*/
    private String sjrszshi;

    /**  收件人所在省*/
    private String sjrszsheng;

    /**  收件人所在县*/
    private String sjrszx;

    /**  收件人详细地址*/
    private String sjrxxdz;

    /**  /领证人名称*/
    private String lzrmc;

    /** 领证人证件种类*/
    private String lzrzjzl;

    /** 领证人证件种类名称*/
    private String lzrzjzlmc;

    /** 领证人证件号*/
    private String lzrzjh;

    private String ddh;

    /** 领证人联系电话*/
    private String lzrlxdh;

    /** 领证详细地址*/
    private String lzxxdz;

    /**
     * 收件人电子邮箱
     */
    private String sjrEmail;

    private String sqid;

    /**
     * 领证时间代码（gx_yy_zd_type.LZSJ）
     */
    private String lzsjdm;

    /**
     * 是否委托 1是0否
     */
    private String sfwt;

    /**
     * 委托开始时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date wtkssj;

    /**
     * 委托结束时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date wtjssj;

    /**
     * 收件人邮编
     */
    private String sjryb;
}
