package cn.gtmap.hlw.core.domain.sqxx.model;

import cn.gtmap.hlw.core.model.*;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/11/29
 * @description
 */
@Data
public class SqxxBatchSaveModel {

    /**
     * 领域事件代码
     */
    private String lysjdm;
    /**
     * 步骤id
     */
    private String processId;
    /**
     * jddm
     */
    private String jddm;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 申请类型
     */
    private String sqlx;
    /**
     * 按钮id
     */
    private String anid;

    /**
     * 项目信息 -申请信息表
     */
    private GxYySqxx sqxx;
    /**
     * 项目信息 -查封信息表
     */
    private GxYySqxxCfxx cfxx;
    /**
     * 抵押信息
     */
    private GxYySqxxDyxx dyxx;
    /**
     * 土地承包经营权
     */
    private GxYySqxxTdcbjy tdcbjy;
    /**
     * 土地承包经营权地块信息
     */
    private GxYySqxxTdcbjydkxx tdcbjyDkxx;
    /**
     * 土地经营权
     */
    private GxYySqxxTdjy tdjy;
    /**
     * 权利人
     */
    private List<GxYyQlr> qlrList;
    /**
     * 义务人
     */
    private List<GxYyQlr> ywrList;
    /**物流信息*/
    private List<GxYySqxxWlxx> wlxxList;
    /**
     * 裁定信息
     */
    private GxYyCdxx cdxx;
    /**
     * 不更新gyfs,默认false
     */
    private Boolean notUpdateGyfs = false;
}
