package cn.gtmap.hlw.core.domain.jyxx.tsjy.model;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.Data;

/**
 * 买卖合同信息
 *
 * @author <a href="mailto:chengong@gtmap.cn">chengong</a>
 * @version 2.0, 2023/04/21
 */
@Data
public class RequestFcjyClfMmhtInfoModel {

    /**
     * 经济机构信息
     */
    private RequestJjjgInfoModel jjjgInfo;

    /**
     * 合同房屋坐落
     */
    private String fwzl;

    /**
     * 土地权证号
     */
    private String tdqzh;

    /**
     * 房屋性质
     */
    private String fwxz;

    /**
     * 所在区域
     */
    private String szqy;

    /**
     * 房屋基本情况其他
     */
    private String fwjbqkqt;

    /**
     * 抵押情况
     */
    private String dyqk;

    /**
     * 租赁情况
     */
    private String zlqk;

    /**
     * 承租人
     */
    private String czr;

    /**
     * 居住权情况
     */
    private String jzqqk;

    /**
     * 居住权情况信息
     */
    private RequestJzqqkInfoModel jzqqkInfo;

    /**
     * 房屋其他情况说明
     */
    private String fwqtqk;

    /**
     * 房屋总价小写金额
     */
    private String fwzjXxje;

    /**
     * 房屋总价大写金额
     */
    private String fwzjDxje;

    /**
     * 首付款
     */
    private String gfk;

    /**
     * 贷款金额
     */
    private String dkje;

    /**
     * 其他款项金额
     */
    private String qtje;

    /**
     * 付款方式
     */
    private String fkfs;

    /**
     * 付款方式信息
     */
    private RequestFkfsInfoModel fkfsInfo;

    /**
     * 资金监管方式
     */
    private String zjjgfs;

    /**
     * 交付日期
     */
    private String jfrq;

    /**
     * 约定登记时间
     */
    private String yddjrq;

    /**
     * 第八条手续方式
     */
    private String sxfs;

    /**
     * 份额约定
     */
    private String feyd;

    /**
     * 取得方式
     */
    @ZdTypeConfig(field = "qdfs", tableName = ZdDzConstant.ZD_DZ_TDQDFS, dmToMc = true)
    private String qdfs;

    /**
     * 土地处理方式
     */
    private String tdclfs;

    /**
     * 土地处理方式其他
     */
    private String tdclfsqt;

    /**
     * 十一条1税费佣金约定方式
     */
    private String yjydfs;

    /**
     * 十一条1税费佣金约定方式其他
     */
    private String yjydfsqt;

    /**
     * 十一条2房屋买卖代理佣金
     */
    private String yjydfs2;

    /**
     * 十一条2房屋买卖代理佣金其他
     */
    private String yjydfsqt2;

    /**
     * 违约金2
     */
    private String wyj2;

    /**
     * 违约金3
     */
    private String wyj3;

    /**
     * 违约金4
     */
    private String wyj4;

    /**
     * 违约金其他
     */
    private String wyjqt;

    /**
     * 合同十三条争议解决方式
     */
    private String zcfs;

    /**
     * 合同份数
     */
    private String htfs;

    /**
     * 卖方合同份数
     */
    private String sellfs;

    /**
     * 买方合同份数
     */
    private String buyfs;

    /**
     * 附件1
     */
    private String fj1;

    /**
     * 附件2
     */
    private String fj2;

    /**
     * 委托合同编号
     */
    private String wthth;
}
