package cn.gtmap.hlw.core.dao.ztfw;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.ztfw.ZtfwDTO;
import cn.gtmap.hlw.core.dto.ztfw.ZtfwQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyZtfw;

import java.util.List;

/**
 * 专题服务表(GxYyZtfw)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-12 13:34:11
 */
public interface GxYyZtfwDao {

    /**
     * 分页查询
     *
     * @param queryDTO
     * @return
     */
    PageInfo<GxYyZtfw> page(ZtfwQueryParamsDTO queryDTO);

    /**
     * 保存更新
     *
     * @param gxYyZtfwPO
     */
    void saveOrUpdateZtfw(GxYyZtfw gxYyZtfwPO);

    /**
     * 删除
     *
     * @param ztfwId
     */
    void delete(String ztfwId);

    /**
     * 集合查询
     *
     * @param queryDTO
     * @return
     */
    List<GxYyZtfw> list(ZtfwQueryParamsDTO queryDTO);

    /**
     * 查询
     *
     * @param ztfwIdList
     * @return
     */
    List<GxYyZtfw> getByZtfwIdList(List<String> ztfwIdList);

    /**
     * 根据角色id获取数据
     *
     * @param roleId 角色id
     * @return 影响行数
     */
    List<GxYyZtfw> getZtfwByRoleId(String roleId);

    /**
     * 专题服务树形
     * @param
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<ZtfwDTO> tree();
}

