package cn.gtmap.hlw.core.dao.log;

import cn.gtmap.hlw.core.dto.log.LogQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyRzBf;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/2/22
 * @description
 */
public interface GxYyRzBfDao {
    /**
     * 根据文件名称和数据来源查询
     *
     * @param fileName
     * @param sjly
     * @return:List<GxYyRzBfPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyRzBf> listByFjmcAndSjly(String fileName, String sjly);

    /**
     * 根据文件名称和数据来源分页查询
     *
     * @param queryDTO
     * @return:PageInfo<RzbfResultDTO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    IPage<GxYyRzBf> queryPage(LogQueryParamsDTO queryDTO);

    GxYyRzBf getById(String id);

    void updateById(GxYyRzBf gxYyRzBf);

    void save(GxYyRzBf gxYyRzBf);
}
