package cn.gtmap.hlw.core.dao.flow;

import cn.gtmap.hlw.core.model.GxYySqlxJdxx;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/12/26
 * @description
 */
public interface GxYySqlxJdxxDao {
    /**
     * 根据sqlx查询
     *
     * @param sqlx
     * @return:List<GxYySqlxJdxxPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqlxJdxx> listBySqlx(String sqlx);

    /**
     * 根据sqlx删除
     *
     * @param sqlxdm
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqlx(String sqlxdm);

    /**
     * 批量保存
     *
     * @param sqlxJdxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatchSomeColumn(List<GxYySqlxJdxx> sqlxJdxxList);

    /**
     * 批量保存或更新
     *
     * @param gxYySqlxJdxxList
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void saveOrUpdateBatch(List<GxYySqlxJdxx> gxYySqlxJdxxList);

    void removeById(String id);
}
