package cn.gtmap.hlw.core.config;

import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;

import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * @Author jianglin
 * @Date 2024/6/27
 * @Description
 */
@Slf4j
public class EncryptResponseWrapper extends HttpServletResponseWrapper {
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);

    public EncryptResponseWrapper(HttpServletResponse resp) {
        super(resp);
    }

    /**
     * 覆盖getWriter()方法，将字符流缓冲到本地
     */
    @Override
    public PrintWriter getWriter() throws IOException {
        return printWriter;
    }

    /**
     * 覆盖getOutputStream()方法，将字节流缓冲到本地
     */
    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream() {
            @Override
            public boolean isReady() {
                return false;
            }

            @Override
            public void setWriteListener(WriteListener writeListener) {

            }

            @Override
            public void write(int b) throws IOException {
                byteArrayOutputStream.write(b);
            }
        };
    }

    /**
     * 把缓冲区内容写入输出流后关闭
     *
     * @author xxj
     */
    public void flush() {
        try {
            printWriter.flush();
            printWriter.close();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        } catch (IOException e) {
            log.error("", e);
        }
    }

    /**
     * 获取字节流
     *
     * @return
     */
    public ByteArrayOutputStream getByteArrayOutputStream() {
        return byteArrayOutputStream;
    }

    /**
     * 将换出区内容转为文本输出
     *
     * @return
     */
    public String getTextContent() {
        flush();
        return byteArrayOutputStream.toString();
    }

    public static boolean isTextContentType(String contentType) {
        boolean flag = false;
        if (StrUtil.isBlank(contentType)) {
            return false;
        } else {
            flag = StrUtil.startWithIgnoreCase(contentType, "text");
            if (!flag) {
                flag = isJsonContentType(contentType);
            }
        }
        return flag;
    }

    public static boolean isJsonContentType(String contentType) {
        return !StrUtil.isBlank(contentType)
                && (StrUtil.containsIgnoreCase(contentType, "application/problem+json")
                || StrUtil.containsIgnoreCase(contentType, MediaType.APPLICATION_JSON_VALUE));
    }
}
