/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.string;

import cn.gtmap.hlw.core.annotation.Desensitized;
import cn.gtmap.hlw.core.enums.SensitiveTypeEnum;
import cn.gtmap.hlw.core.util.encryption.aes.AesUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DesensitizedUtils {
    private static Logger logger = LoggerFactory.getLogger(DesensitizedUtils.class);
    private static final String JAVAX = "javax.";
    private static final String JAVA = "java.";
    public static final String DATATM = "dataTm";
    public static final String ITSELF = "itself";
    @Resource
    private static Environment environment;

    public static void main(String[] args) {
        logger.info("\u9ec4\u5148\u751f:" + DesensitizedUtils.chineseName("\u9ec4\u5148\u751f"));
        logger.info("410923199207092434:" + DesensitizedUtils.idCardNum("410923199207092434 "));
        logger.info("01086484484:" + DesensitizedUtils.fixedPhone("01086484484"));
        logger.info("010-86484484:" + DesensitizedUtils.fixedPhone("010-86484484"));
        logger.info("86484484:" + DesensitizedUtils.fixedPhone("86484484"));
        logger.info("18613881884:" + DesensitizedUtils.mobilePhone("18613881884"));
        logger.info("\u5e02\u533a\u71d5\u8fbe\u82b1\u56edG2\u5e62402\u5ba4" + DesensitizedUtils.address("\u5e02\u533a\u71d5\u8fbe\u82b1\u56edG2\u5e62402\u5ba4"));
        logger.info("1756401745@qq.com:" + DesensitizedUtils.email("1756401745@qq.com"));
        logger.info("6253624001899911:" + DesensitizedUtils.bankCard("6253624001899911"));
        logger.info("625362:" + DesensitizedUtils.companyBankCard("625362"));
        logger.info("\u9646\u6625\u82b1 \u676d\u76ca\u677e" + DesensitizedUtils.ListString("\u9646\u6625\u82b1 \u676d\u76ca\u677e", " ", SensitiveTypeEnum.CHINESE_NAME));
    }

    public static <T> T getBeanByJsonObj(Object json, Class<T> tClass, String attributes) {
        Object t = null;
        try {
            Object getJson = DesensitizedUtils.getJson(JSON.parseObject((String)JSON.toJSONString((Object)json), tClass), attributes);
            t = JSON.parseObject((String)JSON.toJSONString((Object)getJson), tClass);
        }
        catch (Exception e) {
            logger.error("getBeanByJsonObj ERROE", (Throwable)e);
        }
        return (T)t;
    }

    public static <T> List<T> getBeanListByJsonArray(Object obj, Class<T> tClass, String attributes) {
        List t = null;
        try {
            t = JSON.parseArray((String)JSON.toJSONString((Object)obj), tClass);
            if (t == null || t.size() <= 0) {
                return t;
            }
            ArrayList<T> list = new ArrayList<T>();
            for (Object json : t) {
                list.add(DesensitizedUtils.getBeanByJsonObj(json, tClass, attributes));
            }
            return list;
        }
        catch (Exception e) {
            logger.error(" ERROE", (Throwable)e);
            return t;
        }
    }

    public static String ListString(String strings, String Separator, SensitiveTypeEnum annotationType) {
        String[] strList = strings.split(Separator);
        ArrayList<String> list1 = new ArrayList<String>();
        switch (annotationType) {
            case CHINESE_NAME: {
                for (String str : strList) {
                    list1.add(DesensitizedUtils.chineseName(str));
                }
                break;
            }
            case ID_CARD: {
                for (String str : strList) {
                    list1.add(DesensitizedUtils.idCardNum(str));
                }
                break;
            }
            case FIXED_PHONE: {
                for (String str : strList) {
                    list1.add(DesensitizedUtils.fixedPhone(str));
                }
                break;
            }
            case MOBILE_PHONE: {
                for (String str : strList) {
                    list1.add(DesensitizedUtils.mobilePhone(str));
                }
                break;
            }
            case ADDRESS: {
                for (String str : strList) {
                    list1.add(DesensitizedUtils.address(str));
                }
                break;
            }
            case EMAIL: {
                for (String str : strList) {
                    list1.add(DesensitizedUtils.email(str));
                }
                break;
            }
            case BANK_CARD: {
                for (String str : strList) {
                    list1.add(DesensitizedUtils.bankCard(str));
                }
                break;
            }
            case COMPANY_BANK_CARD: {
                for (String str : strList) {
                    list1.add(DesensitizedUtils.companyBankCard(str));
                }
                break;
            }
        }
        return Joiner.on((String)Separator).join(list1);
    }

    public static Object getJson(Object javaBean, String attributes) {
        if (null != javaBean) {
            try {
                if (javaBean.getClass().isInterface()) {
                    return null;
                }
                HashSet<Integer> referenceCounter = new HashSet<Integer>();
                DesensitizedUtils.replace(DesensitizedUtils.getAllFields(javaBean), javaBean, referenceCounter, attributes);
                referenceCounter.clear();
            }
            catch (IllegalAccessException e) {
                logger.error("ERROE\uff1agetJson", (Throwable)e);
            }
        }
        return javaBean;
    }

    private static void replace(Field[] fields, Object javaBean, Set<Integer> referenceCounter, String attributes) throws IllegalAccessException {
        if (null != fields && fields.length > 0) {
            for (Field field : fields) {
                DesensitizedUtils.setAccessible(field);
                if (null == field || null == javaBean) continue;
                Object value = field.get(javaBean);
                if (null != value) {
                    Class<?> type = value.getClass();
                    if (type.isArray()) {
                        int len = Array.getLength(value);
                        for (int i = 0; i < len; ++i) {
                            Object arrayObject = Array.get(value, i);
                            if (!DesensitizedUtils.isNotGeneralType(arrayObject.getClass(), arrayObject, referenceCounter)) continue;
                            DesensitizedUtils.replace(DesensitizedUtils.getAllFields(arrayObject), arrayObject, referenceCounter, attributes);
                        }
                    } else if (value instanceof Collection) {
                        Collection c = (Collection)value;
                        for (Object collectionObj : c) {
                            if (!DesensitizedUtils.isNotGeneralType(collectionObj.getClass(), collectionObj, referenceCounter)) continue;
                            DesensitizedUtils.replace(DesensitizedUtils.getAllFields(collectionObj), collectionObj, referenceCounter, attributes);
                        }
                    } else if (value instanceof Map) {
                        Map m = (Map)value;
                        Set set = m.entrySet();
                        for (Map.Entry o : set) {
                            Map.Entry entry = o;
                            Object mapVal = entry.getValue();
                            if (!DesensitizedUtils.isNotGeneralType(mapVal.getClass(), mapVal, referenceCounter)) continue;
                            DesensitizedUtils.replace(DesensitizedUtils.getAllFields(mapVal), mapVal, referenceCounter, attributes);
                        }
                    } else {
                        if (value instanceof Enum) continue;
                        if (!(type.isPrimitive() || type.getPackage() == null || StringUtils.startsWith((CharSequence)type.getPackage().getName(), (CharSequence)JAVAX) || StringUtils.startsWith((CharSequence)type.getPackage().getName(), (CharSequence)JAVA) || StringUtils.startsWith((CharSequence)field.getType().getName(), (CharSequence)JAVAX) || StringUtils.startsWith((CharSequence)field.getName(), (CharSequence)JAVA) || !referenceCounter.add(value.hashCode()))) {
                            DesensitizedUtils.replace(DesensitizedUtils.getAllFields(value), value, referenceCounter, attributes);
                        }
                    }
                }
                DesensitizedUtils.setNewValueForField(javaBean, field, value, attributes);
            }
        }
    }

    public static Field[] getAllFields(Object objSource) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = objSource.getClass(); tempClass != null && !tempClass.getName().equalsIgnoreCase("java.lang.object"); tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    private static boolean isNotGeneralType(Class<?> clazz, Object value, Set<Integer> referenceCounter) {
        return !clazz.isPrimitive() && clazz.getPackage() != null && !clazz.isEnum() && !StringUtils.startsWith((CharSequence)clazz.getPackage().getName(), (CharSequence)JAVAX) && !StringUtils.startsWith((CharSequence)clazz.getPackage().getName(), (CharSequence)JAVA) && !StringUtils.startsWith((CharSequence)clazz.getName(), (CharSequence)JAVAX) && !StringUtils.startsWith((CharSequence)clazz.getName(), (CharSequence)JAVA) && referenceCounter.add(value.hashCode());
    }

    public static void setNewValueForField(Object javaBean, Field field, Object value, String attributes) throws IllegalAccessException {
        String valueStr;
        Desensitized annotation = field.getAnnotation(Desensitized.class);
        if (field.getType().equals(String.class) && null != annotation && DesensitizedUtils.executeIsEffictiveMethod(javaBean, annotation) && StringUtils.isNotBlank((CharSequence)(valueStr = (String)value))) {
            Class<?> clazz = javaBean.getClass();
            try {
                if (DATATM.equals(attributes)) {
                    if (annotation.isEncrypter() && StringUtils.isNotBlank((CharSequence)valueStr)) {
                        field.set(javaBean, AesUtil.encrypt(valueStr, environment.getProperty("aes_key")));
                    }
                    field = clazz.getDeclaredField(field.getName() + "Tm");
                    DesensitizedUtils.setAccessible(field);
                }
                switch (annotation.type()) {
                    case CHINESE_NAME: {
                        if ("".equals(annotation.separator())) {
                            field.set(javaBean, DesensitizedUtils.chineseName(valueStr));
                            break;
                        }
                        field.set(javaBean, DesensitizedUtils.ListString(valueStr, annotation.separator(), annotation.type()));
                        break;
                    }
                    case ID_CARD: {
                        if ("".equals(annotation.separator())) {
                            field.set(javaBean, DesensitizedUtils.idCardNum(valueStr));
                            break;
                        }
                        field.set(javaBean, DesensitizedUtils.ListString(valueStr, annotation.separator(), annotation.type()));
                        break;
                    }
                    case FIXED_PHONE: {
                        if ("".equals(annotation.separator())) {
                            field.set(javaBean, DesensitizedUtils.fixedPhone(valueStr));
                            break;
                        }
                        field.set(javaBean, DesensitizedUtils.ListString(valueStr, annotation.separator(), annotation.type()));
                        break;
                    }
                    case MOBILE_PHONE: {
                        if ("".equals(annotation.separator())) {
                            field.set(javaBean, DesensitizedUtils.mobilePhone(valueStr));
                            break;
                        }
                        field.set(javaBean, DesensitizedUtils.ListString(valueStr, annotation.separator(), annotation.type()));
                        break;
                    }
                    case ADDRESS: {
                        if ("".equals(annotation.separator())) {
                            field.set(javaBean, DesensitizedUtils.address(valueStr));
                            break;
                        }
                        field.set(javaBean, DesensitizedUtils.ListString(valueStr, annotation.separator(), annotation.type()));
                        break;
                    }
                    case EMAIL: {
                        if ("".equals(annotation.separator())) {
                            field.set(javaBean, DesensitizedUtils.email(valueStr));
                            break;
                        }
                        field.set(javaBean, DesensitizedUtils.ListString(valueStr, annotation.separator(), annotation.type()));
                        break;
                    }
                    case BANK_CARD: {
                        if ("".equals(annotation.separator())) {
                            field.set(javaBean, DesensitizedUtils.bankCard(valueStr));
                            break;
                        }
                        field.set(javaBean, DesensitizedUtils.ListString(valueStr, annotation.separator(), annotation.type()));
                        break;
                    }
                    case COMPANY_BANK_CARD: {
                        if ("".equals(annotation.separator())) {
                            field.set(javaBean, DesensitizedUtils.companyBankCard(valueStr));
                            break;
                        }
                        field.set(javaBean, DesensitizedUtils.ListString(valueStr, annotation.separator(), annotation.type()));
                        break;
                    }
                    case PASSWORD: {
                        if ("".equals(annotation.separator())) {
                            field.set(javaBean, DesensitizedUtils.password(valueStr));
                            break;
                        }
                        field.set(javaBean, DesensitizedUtils.ListString(valueStr, annotation.separator(), annotation.type()));
                        break;
                    }
                }
            }
            catch (NoSuchFieldException e) {
                logger.error("ERROE\uff1asetNewValueForField", (Throwable)e);
            }
        }
    }

    private static void setAccessible(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    private static boolean executeIsEffictiveMethod(Object javaBean, Desensitized desensitized) {
        String isEffictiveMethod;
        boolean isAnnotationEffictive = true;
        if (desensitized != null && DesensitizedUtils.isNotEmpty(isEffictiveMethod = desensitized.isEffictiveMethod())) {
            try {
                Method method = javaBean.getClass().getMethod(isEffictiveMethod, new Class[0]);
                method.setAccessible(true);
                isAnnotationEffictive = (Boolean)method.invoke(javaBean, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error("ERROE\uff1aexecuteIsEffictiveMethod", (Throwable)e);
            }
        }
        return isAnnotationEffictive;
    }

    private static boolean isNotEmpty(String str) {
        return str != null && !"".equals(str);
    }

    private static boolean isEmpty(String str) {
        return !DesensitizedUtils.isNotEmpty(str);
    }

    public static String chineseName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.right((String)fullName, (int)1);
        return StringUtils.leftPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }

    public static String idCardNum(String id) {
        id = StringUtils.trim((String)id);
        int length = StringUtils.length((CharSequence)id);
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)id, (int)4), (int)StringUtils.length((CharSequence)id), (String)"*");
    }

    public static String idCardNumByBirthday(String id) {
        id = StringUtils.trim((String)id);
        int length = StringUtils.length((CharSequence)id);
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        return StringUtils.left((String)id, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)id, (int)4), (int)(StringUtils.length((CharSequence)id) - 9), (String)"*"), (String)"*"));
    }

    public static String fixedPhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)StringUtils.length((CharSequence)num), (String)"*");
    }

    public static String mobilePhone(String num) {
        if (StringUtils.isBlank((CharSequence)(num = StringUtils.trim((String)num)))) {
            return "";
        }
        if (11 != num.trim().length()) {
            return num;
        }
        return StringUtils.left((String)num, (int)3).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)(StringUtils.length((CharSequence)num) - 2), (String)"*"), (String)"*"));
    }

    public static String address(String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)address);
        return StringUtils.leftPad((String)StringUtils.right((String)address, (int)6), (int)length, (String)"*");
    }

    public static String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)0), (int)index, (String)"*").concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((CharSequence)email)));
    }

    public static String bankCard(String cardNum) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        return StringUtils.left((String)cardNum, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)4), (int)StringUtils.length((CharSequence)cardNum), (String)"*"), (String)"******"));
    }

    public static String companyBankCard(String companyBardNum) {
        if (StringUtils.isBlank((CharSequence)companyBardNum)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)companyBardNum);
        return StringUtils.rightPad((String)StringUtils.left((String)companyBardNum, (int)2), (int)length, (String)"*");
    }

    public static String password(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return "";
        }
        String pwd = StringUtils.left((String)password, (int)0);
        return StringUtils.rightPad((String)pwd, (int)StringUtils.length((CharSequence)password), (String)"*");
    }
}

