/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.validator;

import cn.gtmap.hlw.core.annotation.validator.IdCardCheck;
import cn.gtmap.hlw.core.enums.dict.ZjlxEnum;
import cn.gtmap.hlw.core.util.validator.ValidationUtils;
import java.util.Calendar;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class IdCardCheckValidator
implements ConstraintValidator<IdCardCheck, String> {
    private String message;

    public void initialize(IdCardCheck constraintAnnotation) {
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(String str, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isBlank((CharSequence)str) || StringUtils.contains((CharSequence)"-", (CharSequence)str)) {
            return true;
        }
        String[] split = str.split("-");
        String zjlx = split[1];
        if (!StringUtils.equals((CharSequence)zjlx, (CharSequence)ZjlxEnum.SFZJZL_SFZ.getCode())) {
            return true;
        }
        str = split[0];
        if (StringUtils.isBlank((CharSequence)str)) {
            return true;
        }
        if ((str = str.toUpperCase()).length() != 15 && str.length() != 18) {
            ValidationUtils.reset(constraintValidatorContext, String.valueOf(str) + "-" + this.message);
            return false;
        }
        int y = 0;
        int m = 0;
        int d = 0;
        if (str.length() == 15) {
            y = Integer.parseInt("19" + str.substring(6, 8), 10);
            m = Integer.parseInt(str.substring(8, 10), 10);
            d = Integer.parseInt(str.substring(10, 12), 10);
        } else if (str.length() == 18) {
            if (str.indexOf("X") >= 0 && str.indexOf("X") != 17) {
                ValidationUtils.reset(constraintValidatorContext, String.valueOf(str) + "-" + this.message);
                return false;
            }
            char verifyBit = IdCardCheckValidator.getVerifyBit(str);
            if (str.charAt(17) != verifyBit) {
                ValidationUtils.reset(constraintValidatorContext, String.valueOf(str) + "-" + this.message);
                return false;
            }
            y = Integer.parseInt(str.substring(6, 10), 10);
            m = Integer.parseInt(str.substring(10, 12), 10);
            d = Integer.parseInt(str.substring(12, 14), 10);
        }
        int currentY = Calendar.getInstance().get(1);
        if (y > currentY || y < 1870) {
            ValidationUtils.reset(constraintValidatorContext, String.valueOf(str) + "-" + this.message);
            return false;
        }
        if (m < 1 || m > 12) {
            ValidationUtils.reset(constraintValidatorContext, String.valueOf(str) + "-" + this.message);
            return false;
        }
        if (d < 1 || d > 31) {
            ValidationUtils.reset(constraintValidatorContext, String.valueOf(str) + "-" + this.message);
            return false;
        }
        return true;
    }

    private static char getVerifyBit(String str) {
        char verifyBit = '\u0000';
        int sum = (str.charAt(0) - 48) * 7 + (str.charAt(1) - 48) * 9 + (str.charAt(2) - 48) * 10 + (str.charAt(3) - 48) * 5 + (str.charAt(4) - 48) * 8 + (str.charAt(5) - 48) * 4 + (str.charAt(6) - 48) * 2 + (str.charAt(7) - 48) * 1 + (str.charAt(8) - 48) * 6 + (str.charAt(9) - 48) * 3 + (str.charAt(10) - 48) * 7 + (str.charAt(11) - 48) * 9 + (str.charAt(12) - 48) * 10 + (str.charAt(13) - 48) * 5 + (str.charAt(14) - 48) * 8 + (str.charAt(15) - 48) * 4 + (str.charAt(16) - 48) * 2;
        char[] verifyBits = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        if ((sum %= 11) >= 0 && sum < verifyBits.length) {
            verifyBit = verifyBits[sum];
        }
        return verifyBit;
    }
}

