/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.string;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);
    public static final String NULL = "null";
    public static final String EMPTY = "";
    public static final String SPACE = " ";
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "\u6574";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";
    private static final Pattern PATTERN_BASE64 = Pattern.compile("^data.(.*?);base64,");
    public static final String BDCQ_BH_LEFT_BRACKET = "(";
    public static final String BDCQ_BH_RIGHT_BRACKET = ")";
    public static final String BDCQ_BH_LEFT_BRACKET_CN = "\uff08";
    public static final String BDCQ_BH_RIGHT_BRACKET_CN = "\uff09";
    public static final String ENCODING_UTF8 = "UTF-8";
    private static final Random RANDOM = new Random();
    private static Pattern ZW_PATTERN = Pattern.compile("[\u4e00-\u9fa5]");

    public static synchronized String generateSlbh() {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss");
        String nowDate = sf.format(new Date());
        int radInt = RANDOM.nextInt(999);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumIntegerDigits(3);
        nf.setMinimumIntegerDigits(3);
        String radStr = nf.format(radInt);
        String slbh = String.format("%s%s", nowDate, radStr);
        return slbh;
    }

    public static synchronized String getBusinessOrder() {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String nowDate = sf.format(new Date());
        Random random = new Random();
        int radInt = random.nextInt(999);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumIntegerDigits(3);
        nf.setMinimumIntegerDigits(3);
        String radStr = nf.format(radInt);
        String businessOrder = String.format("%s%s", nowDate, radStr);
        return businessOrder;
    }

    public static boolean isContainEmpty(String ... args) {
        if (args == null) {
            return false;
        }
        int len = args.length;
        int i = 0;
        while (i < len) {
            String arg = args[i];
            if (arg == null || arg.isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEquals(String value, String ... args) {
        if (args == null && StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            if (args == null) {
                return false;
            }
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (value.equals(arg)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isBase64(String str) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(base64Pattern, str);
    }

    public static String hex32() {
        String str = UUID.randomUUID().toString();
        return str.replace("-", EMPTY);
    }

    public static String xssEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    break;
                }
                case '<': {
                    sb.append('\uff1c');
                    break;
                }
                case '\'': {
                    sb.append('\u2018');
                    break;
                }
                case '\"': {
                    sb.append('\u201c');
                    break;
                }
                case '&': {
                    sb.append('\uff06');
                    break;
                }
                case '\\': {
                    sb.append('\uff3c');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isChinese(String str) {
        Matcher matcher;
        boolean flg = false;
        if (StringUtils.isNotBlank((CharSequence)str) && (matcher = ZW_PATTERN.matcher(str)).find()) {
            flg = true;
        }
        return flg;
    }

    public static String toString(Object obj) {
        return obj != null ? obj.toString() : EMPTY;
    }

    public static String generateVerificationCode(int length) {
        String characters = "0123456789";
        StringBuilder code = new StringBuilder();
        int i = 0;
        while (i < length) {
            char randomChar = characters.charAt(RANDOM.nextInt(characters.length()));
            code.append(randomChar);
            ++i;
        }
        return code.toString();
    }

    public static boolean indexOfStrs(String[] a, String b) {
        boolean flag = false;
        if (a != null) {
            String[] stringArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                if (StringUtils.equals((CharSequence)c, (CharSequence)b)) {
                    flag = true;
                    break;
                }
                ++n2;
            }
        }
        return flag;
    }

    public static String removeChineseAndBrackets(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str = str.replaceAll("[\u4e00-\u9fa5()\uff08\uff09]", EMPTY);
        }
        return str;
    }

    public static String double6ToStr(Double d) {
        if (d == null) {
            return EMPTY;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(6);
        return nf.format(d);
    }

    public static double convertWanToYuan(String amountInWanStr) {
        double amountInWan = Double.parseDouble(amountInWanStr);
        return amountInWan * 10000.0;
    }

    public static Double convertWanToYuan(Double amountInWanStr) {
        if (amountInWanStr != null) {
            return amountInWanStr * 10000.0;
        }
        return null;
    }

    public static String convertWanToYuanStr(String amountInWanStr) {
        if (StringUtils.isNotBlank((CharSequence)amountInWanStr)) {
            double amountInWan = Double.parseDouble(amountInWanStr);
            double mul = NumberUtil.mul((double)amountInWan, (float)10000.0f);
            NumberFormat nf = NumberFormat.getInstance();
            nf.setGroupingUsed(false);
            return nf.format(mul);
        }
        return EMPTY;
    }

    public static String convertWanToYuanStr(Double amountInWan) {
        if (amountInWan != null) {
            double value = amountInWan;
            double mul = NumberUtil.mul((double)value, (float)10000.0f);
            NumberFormat nf = NumberFormat.getInstance();
            nf.setGroupingUsed(false);
            return nf.format(mul);
        }
        return EMPTY;
    }

    public static String convertYuanToWanStr(String amount) {
        if (StringUtils.isBlank((CharSequence)amount)) {
            return amount;
        }
        try {
            double yuanAmount = Double.parseDouble(amount);
            double wanYuanAmount = yuanAmount / 10000.0;
            DecimalFormat df = new DecimalFormat("#.######");
            return df.format(wanYuanAmount);
        }
        catch (NumberFormatException e) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u4e07\u5143\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static String convertYuanToWanStr(Double amountInYuan) {
        if (amountInYuan != null) {
            double value = amountInYuan;
            double mul = NumberUtil.div((double)value, (float)10000.0f);
            DecimalFormat df = new DecimalFormat("#.######");
            return df.format(mul);
        }
        return EMPTY;
    }

    public static Double convertYuanToWan(Double amountInYuan) {
        if (amountInYuan == null) {
            return amountInYuan;
        }
        return amountInYuan / 10000.0;
    }

    public static String trimJsonKey(JSONObject json) {
        Iterator iterator = json.keySet().iterator();
        JSONObject jsonObject = new JSONObject();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = json.get((Object)key);
            if (key.contains(SPACE)) {
                key = key.replace(SPACE, EMPTY);
            }
            jsonObject.put(key, value);
            if (json.get((Object)key) instanceof JSONObject) {
                String s = StringUtil.trimJsonKey((JSONObject)json.get((Object)key));
                jsonObject.put(key, (Object)JSONObject.parseObject((String)s));
                continue;
            }
            if (!(json.get((Object)key) instanceof JSONArray)) continue;
            JSONArray array = (JSONArray)json.get((Object)key);
            JSONArray jsonArray = new JSONArray();
            for (Object item : array) {
                if (!(item instanceof JSONObject)) continue;
                String s = StringUtil.trimJsonKey((JSONObject)item);
                jsonArray.add((Object)JSONObject.parseObject((String)s));
            }
            jsonObject.put(key, (Object)jsonArray);
        }
        return jsonObject.toJSONString();
    }

    public static StringBuilder appendBuilder(StringBuilder sb, CharSequence ... strs) {
        CharSequence[] charSequenceArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence str = charSequenceArray[n2];
            sb.append(str);
            ++n2;
        }
        return sb;
    }

    public static String removeBase64Pre(String base64Str) {
        Matcher matcher;
        if (StringUtils.isNotBlank((CharSequence)base64Str) && (matcher = PATTERN_BASE64.matcher(base64Str)).find()) {
            return base64Str.replace(matcher.group(), EMPTY);
        }
        return base64Str;
    }

    public static String decodeBase64(String base64Str) {
        String str = EMPTY;
        if (StringUtils.isNotBlank((CharSequence)base64Str)) {
            str = new String(Base64.decodeBase64((String)base64Str));
        }
        if (str.indexOf(BDCQ_BH_LEFT_BRACKET_CN) != -1) {
            str = str.replace(BDCQ_BH_LEFT_BRACKET_CN, BDCQ_BH_LEFT_BRACKET);
        }
        if (str.indexOf(BDCQ_BH_RIGHT_BRACKET_CN) != -1) {
            str = str.replace(BDCQ_BH_RIGHT_BRACKET_CN, BDCQ_BH_RIGHT_BRACKET);
        }
        return str;
    }

    public static String encodeBase64(String str) {
        String base64Str = EMPTY;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            base64Str = Base64.encodeBase64String((byte[])str.getBytes());
        }
        return base64Str;
    }

    public static String getGUID() {
        StringBuilder uid = new StringBuilder();
        SecureRandom rd = new SecureRandom();
        int i = 0;
        while (i < 16) {
            int type = rd.nextInt(3);
            switch (type) {
                case 0: {
                    uid.append(rd.nextInt(10));
                    break;
                }
                case 1: {
                    uid.append((char)(rd.nextInt(25) + 65));
                    break;
                }
                case 2: {
                    uid.append((char)(rd.nextInt(25) + 97));
                    break;
                }
            }
            ++i;
        }
        return uid.toString();
    }

    public static boolean isDecimal(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("-?\\d+\\.\\d+([eE][-+]?\\d+)?");
    }

    public static byte[] decodeBase64StrToByte(String base64Str) {
        byte[] bytes = null;
        if (StringUtils.isNotBlank((CharSequence)base64Str)) {
            bytes = Base64.decodeBase64((String)base64Str);
        }
        return bytes;
    }

    public static byte[] strToByteUtf8(String str) {
        return StringUtil.strToByte(str, ENCODING_UTF8);
    }

    public static byte[] strToByte(String str, String encode) {
        byte[] b = null;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                b = str.getBytes(encode);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return b;
    }

    public static String byteToStrUtf8(byte[] b) {
        return StringUtil.byteToStr(b, ENCODING_UTF8);
    }

    public static String byteToStr(byte[] b, String encode) {
        String str = null;
        if (b != null) {
            try {
                str = new String(b, encode);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return str;
    }

    public static String join(Collection<?> collection, String delimiter) {
        if (CollectionUtils.isEmpty(collection)) {
            return EMPTY;
        }
        Collection filteredCollection = collection.stream().filter(obj -> obj != null && !obj.toString().isEmpty()).collect(Collectors.toList());
        return StringUtils.join((Iterable)filteredCollection, (String)delimiter);
    }

    public static List<String> getSeparatorString(String str) {
        ArrayList array = null;
        if (str != null) {
            String realStr = str.trim().replaceAll("\\s+", SPACE);
            if (realStr.contains(";")) {
                array = Lists.newArrayList((Object[])realStr.split(";"));
            } else if (realStr.contains("\uff1b")) {
                array = Lists.newArrayList((Object[])realStr.split("\uff1b"));
            } else if (realStr.contains(",")) {
                array = Lists.newArrayList((Object[])realStr.split(","));
            } else if (realStr.contains("\uff0c")) {
                array = Lists.newArrayList((Object[])realStr.split("\uff0c"));
            } else if (realStr.contains(SPACE)) {
                array = Lists.newArrayList((Object[])realStr.split(SPACE));
            } else if (realStr.contains("\u3001")) {
                array = Lists.newArrayList((Object[])realStr.split("\u3001"));
            } else {
                array = new ArrayList();
                array.add(realStr);
            }
        }
        return array;
    }

    public static String extractParam(String data, String paramName) {
        int index = data.indexOf(paramName);
        if (index == -1) {
            return null;
        }
        String paramid = data.substring(index + paramName.length());
        int endIndex = paramid.indexOf("&");
        if (endIndex != -1) {
            paramid = paramid.substring(0, endIndex);
        }
        return paramid;
    }

    public static boolean isJson(String jsonString) {
        if (StringUtils.isNotBlank((CharSequence)jsonString)) {
            try {
                JSON.parseObject((String)jsonString);
                return true;
            }
            catch (Exception e) {
                log.info("\u5b57\u7b26\u4e32\u4e0d\u662fjson\u4e32,{}", (Object)e.getMessage());
                return false;
            }
        }
        return false;
    }
}

