/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.pdf;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.util.string.StringUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class NumberUtil {
    public static Boolean sfzhSfWcn(String idCardNumber) {
        String dateStr = idCardNumber.substring(6, 14);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date birthDate = null;
        try {
            birthDate = dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            throw new BizException((IError)ErrorEnum.SERVICE_ERROR, (Throwable)e);
        }
        int age = 0;
        if (birthDate != null) {
            Date currentDate = new Date();
            long diff = currentDate.getTime() - birthDate.getTime();
            long years = diff / 31536000000L;
            age = (int)years;
        }
        if (age < 18) {
            return true;
        }
        return false;
    }

    public static String convertQlbl(String qlbl) {
        double qlblDouble;
        BigDecimal qlblBig;
        if (StringUtils.isBlank((CharSequence)qlbl)) {
            return null;
        }
        if (StringUtil.isChinese(qlbl)) {
            return null;
        }
        if (qlbl.contains("/")) {
            return qlbl;
        }
        if (qlbl.endsWith("%")) {
            qlbl = qlbl.replace("%", "");
        }
        if ((qlblBig = BigDecimal.valueOf(qlblDouble = Double.parseDouble(qlbl))).compareTo(BigDecimal.ONE) <= 0) {
            return qlbl;
        }
        return CommonUtil.formatEmptyValue((Object)qlblBig.divide(new BigDecimal(100L), 2, 4));
    }

    public static String removeTrailingZeros(String number) {
        if (number == null) {
            return null;
        }
        return number.replaceAll("(\\.\\d*?[1-9])0+$", "$1").replaceAll("\\.0+$", "");
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            Pattern pattern = Pattern.compile("[0-9]*");
            return pattern.matcher(str).matches();
        }
        return false;
    }
}

