/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.pdf;

import java.math.BigDecimal;

public class NumberToCnUtil {
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "\u6574";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";

    public static String number2CnMontrayUnit(BigDecimal numberOfMoney) {
        StringBuffer sb = new StringBuffer();
        int signum = numberOfMoney.signum();
        if (signum == 0) {
            return CN_ZEOR_FULL;
        }
        long number = numberOfMoney.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                    }
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        if (scale <= 0L) {
            sb.append(CN_FULL);
        }
        return sb.toString();
    }

    public static String convert(String number) {
        String[] num = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] unit = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343", "\u4e07\u4ebf"};
        char[] ch = number.toCharArray();
        StringBuilder str = new StringBuilder();
        int length = ch.length;
        int i = 0;
        while (i < length) {
            int c = ch[i] - 48;
            if (c != 0) {
                str.append(num[c]).append(unit[length - i - 1]);
            } else {
                str.append(num[c]);
            }
            ++i;
        }
        return str.toString();
    }

    public static String number2CnMontrayUnit(Double je) {
        if (je != null) {
            BigDecimal dyjeBigDecimal = BigDecimal.valueOf(je);
            return NumberToCnUtil.number2CnMontrayUnit(dyjeBigDecimal);
        }
        return "";
    }

    public static void main(String[] args) {
        double money = 2020004.01;
        BigDecimal numberOfMoney = BigDecimal.valueOf(money);
        String s = NumberToCnUtil.number2CnMontrayUnit(numberOfMoney);
    }
}

