/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.jwt;

import cn.gtmap.hlw.core.base.UserInfo;
import cn.gtmap.hlw.core.enums.error.TokenErrorEnum;
import cn.gtmap.hlw.core.exception.TokenException;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.thread.ThreadLocalUtils;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Jwt {
    private static int expireDate;
    private static String SECRET;

    static {
        SECRET = "lww9227wxb1992hyk920709sl017zp17";
    }

    public static int getExpireDate() {
        return expireDate;
    }

    public static void setExpireDate(int expireDate) {
        Jwt.expireDate = expireDate;
    }

    public static String creatToken(Map<String, String> map) {
        JWTCreator.Builder builder = JWT.create();
        map.forEach((k, v) -> {
            JWTCreator.Builder builder2 = builder.withClaim(k, v);
        });
        Calendar instance = Calendar.getInstance();
        instance.add(12, expireDate);
        builder.withExpiresAt(instance.getTime());
        return builder.sign(Algorithm.HMAC256((String)SECRET));
    }

    public static void verify(String token) {
        JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).build().verify(token);
    }

    public static DecodedJWT getToken(String token) {
        return JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).build().verify(token);
    }

    public static Map<String, String> getPayload(String token) {
        HashMap map = Maps.newHashMap();
        DecodedJWT decode = JWT.decode((String)token);
        Map claimMap = decode.getClaims();
        if (Objects.isNull(claimMap)) {
            throw new TokenException(TokenErrorEnum.EMPTY_TOKEN_ERROR);
        }
        for (Map.Entry entry : claimMap.entrySet()) {
            map.put((String)entry.getKey(), decode.getClaim((String)entry.getKey()).asString());
        }
        Object userInfo = BeanConvertUtil.convertMap(map, UserInfo.class);
        ThreadLocalUtils.set("userInfo", userInfo);
        return map;
    }
}

