/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.http;

import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerMapping;

public class HttpContextUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpContextUtils.class);

    public static Map<String, Object> getParameterMapAll(HttpServletRequest request) {
        Enumeration parameters = request.getParameterNames();
        HashMap params = Maps.newHashMap();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            String value = Sm2lib.decode(parameter);
            params.put(parameter, value);
        }
        return params;
    }

    public static String getBodyString(ServletRequest request) {
        StringBuilder sb;
        block18: {
            sb = new StringBuilder();
            ServletInputStream inputStream = null;
            BufferedReader reader = null;
            try {
                try {
                    inputStream = request.getInputStream();
                    reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException e) {
                    logger.error("request\u89e3\u6790Body\u8bf7\u6c42\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                        break block18;
                    }
                    catch (IOException e2) {
                        logger.error("request\u89e3\u6790Body\u8bf7\u6c42\u4fe1\u606f\u5f02\u5e38:", (Throwable)e2);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    logger.error("request\u89e3\u6790Body\u8bf7\u6c42\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.error("request\u89e3\u6790Body\u8bf7\u6c42\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static Map<String, String> getPathString(HttpServletRequest request) {
        HashMap params = Maps.newHashMap();
        Map pathVars = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (!pathVars.isEmpty()) {
            Set entrySet = pathVars.entrySet();
            for (Map.Entry entry : entrySet) {
                params.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return params;
    }

    public static String getParams(HttpServletRequest request) {
        String requestBody;
        Map<String, String> pathMap;
        StringBuilder sb = new StringBuilder();
        Map<String, Object> parameterMap = HttpContextUtils.getParameterMapAll(request);
        if (!parameterMap.isEmpty()) {
            sb.append(parameterMap);
        }
        if (!(pathMap = HttpContextUtils.getPathString(request)).isEmpty()) {
            sb.append(pathMap);
        }
        if (StringUtils.isNotEmpty((CharSequence)(requestBody = HttpContextUtils.getBodyString((ServletRequest)request)))) {
            sb.append(requestBody);
        }
        return sb.toString().replaceAll(" ", "");
    }
}

