/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.http;

import cn.gtmap.hlw.core.dto.third.dzzz.DzzzShieldSyncAppDTO;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.util.encryption.Md5Util;
import cn.gtmap.hlw.core.util.http.ShieldSyncApp;
import com.alibaba.fastjson.JSONObject;
import com.iflytek.fsp.shield.java.sdk.http.BaseApp;
import com.iflytek.fsp.shield.java.sdk.model.ApiResponse;
import epoint.frame.encrypt.sm2.SM2Util;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DzzzUtils
extends BaseApp {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DzzzUtils.class);

    public static String sendRequest(DzzzShieldSyncAppDTO appDTO, String method, String privateKey, String enc) {
        block4: {
            String res = "";
            ShieldSyncApp test = new ShieldSyncApp(appDTO);
            String timestamp = String.valueOf(System.currentTimeMillis());
            String nonce = UUID.randomUUID().toString();
            String unSign = String.valueOf(test.getAppId()) + method + timestamp + nonce;
            log.info("timestamp: {}", (Object)timestamp);
            log.info("nonce: {}", (Object)nonce);
            log.info("unSign: {}", (Object)unSign);
            log.info("appId:{}", (Object)test.getAppId());
            String sign = Md5Util.encode(unSign);
            log.info("MD5\u52a0\u5bc6\u540e\u7684sign:{}", (Object)sign);
            try {
                byte[] bytes = enc.getBytes(StandardCharsets.UTF_8);
                ApiResponse response = test.ZZK_OPENAPI_GATEWAY(bytes, method, timestamp, nonce, sign);
                res = new String(response.getBody(), StandardCharsets.UTF_8);
                log.info("\u89e3\u5bc6\u524d\u7ed3\u679c:{}", (Object)res);
                JSONObject resObj = JSONObject.parseObject((String)res);
                if (resObj.getBooleanValue("success")) {
                    String data = resObj.getString("data");
                    if (data != null && !StringUtils.equals((CharSequence)data, (CharSequence)"null")) {
                        SM2Util sm2DecUtil = new SM2Util(null, privateKey);
                        res = sm2DecUtil.decrypt(data);
                        log.info("\u89e3\u5bc6\u7ed3\u679c:{}", (Object)res);
                        return res;
                    }
                    break block4;
                }
                throw new BizException(ErrorEnum.FAIL.getCode(), resObj.getString("errorMessage"));
            }
            catch (Exception e) {
                log.error("DzzzUtils.sendRequest", (Throwable)e);
                throw new BizException(ErrorEnum.FAIL.getCode(), e.getMessage());
            }
        }
        return "";
    }

    public static String encrypt(String publicKey, String str) {
        String enc;
        SM2Util sm2EncUtil = new SM2Util(publicKey, null);
        log.info("\u539f\u59cb\u5185\u5bb9\uff1a" + str);
        try {
            enc = sm2EncUtil.encrypt(str);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.info("\u52a0\u5bc6\u7ed3\u679c\uff1a" + enc);
        return enc;
    }
}

