/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.file;

import com.gtis.config.AppConfig;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfToImageUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfToImageUtils.class);

    public static String pdfToPic(byte[] fileContent, String wjlx) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PDDocument document = PDDocument.load((byte[])fileContent);){
                PDFRenderer renderer = new PDFRenderer(document);
                ArrayList<BufferedImage> piclist = new ArrayList<BufferedImage>();
                int actSize = document.getNumberOfPages();
                float dpi = 300.0f;
                String pdfExchangeDpi = AppConfig.getProperty((String)"pdf.exchange.dpi");
                if (StringUtils.isNotBlank((CharSequence)pdfExchangeDpi)) {
                    dpi = Float.parseFloat(pdfExchangeDpi);
                }
                int i = 0;
                while (i < document.getNumberOfPages()) {
                    piclist.add(renderer.renderImageWithDPI(i, dpi));
                    ++i;
                }
                byte[] result = PdfToImageUtils.pjPic(piclist, wjlx);
                String string = result == null ? null : Base64.getEncoder().encodeToString(result);
                return string;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] pjPic(List<BufferedImage> piclist, String wjlx) {
        if (piclist == null || piclist.size() <= 0) {
            log.info("\u56fe\u7247\u6570\u7ec4\u4e3a\u7a7a!");
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int height = 0;
                int width = 0;
                int heightTemp = 0;
                int heightEach = 0;
                int picNum = piclist.size();
                Object fileImg = null;
                int[] heightArray = new int[picNum];
                BufferedImage buffer = null;
                ArrayList<int[]> imgRGB = new ArrayList<int[]>();
                int i = 0;
                while (i < picNum) {
                    buffer = piclist.get(i);
                    heightArray[i] = heightTemp = buffer.getHeight();
                    if (i == 0) {
                        width = buffer.getWidth();
                    }
                    height += heightTemp;
                    int[] imgRGBTemp = new int[width * heightTemp];
                    imgRGBTemp = buffer.getRGB(0, 0, width, heightTemp, imgRGBTemp, 0, width);
                    imgRGB.add(imgRGBTemp);
                    ++i;
                }
                heightTemp = 0;
                BufferedImage imageResult = new BufferedImage(width, height, 1);
                int i2 = 0;
                while (i2 < picNum) {
                    heightEach = heightArray[i2];
                    if (i2 != 0) {
                        heightTemp += heightEach;
                    }
                    imageResult.setRGB(0, heightTemp, width, heightEach, (int[])imgRGB.get(i2), 0, width);
                    ++i2;
                }
                ImageIO.write((RenderedImage)imageResult, wjlx, out);
                return out.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

