/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.file;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.util.date.DateUtils;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.gtis.config.AppConfig;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static final int BUFFER_SIZE = 0x100000;

    public static File uploadFile(String uploadFilePath, String fileName, byte[] file) {
        if (StringUtils.isNotBlank((CharSequence)uploadFilePath)) {
            FileUtil.mkdir((String)uploadFilePath);
            return FileUtil.writeBytes((byte[])file, (String)(String.valueOf(uploadFilePath) + File.separator + fileName));
        }
        return null;
    }

    public static void uploadBase64File(String uploadFilePath, String fileName, String base64Str) {
        base64Str = base64Str.replace("data:image/jpeg;base64,", "").replace("data:image/png;base64,", "").replace("data:image/gif;base64,", "").replace("data:image/jpg;base64,", "").replace("data:image/png;base64,", "");
        try {
            byte[] bytes = Base64.getDecoder().decode(base64Str);
            FileUtils.uploadFile(uploadFilePath, fileName, bytes);
        }
        catch (Exception e) {
            logger.error("uploadBase64File  ERROR\uff1a{}", (Object)e.getMessage());
            throw new BizException((IError)ErrorEnum.SERVICE_ERROR, "\u4e0a\u4f20base64\u5b57\u7b26\u4e32\u6587\u4ef6\u5230\u6307\u5b9a\u8def\u5f84\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static String getFjBase64(String filepath, String fjmc) {
        byte[] fileContent;
        File file;
        if (StringUtils.isNotBlank((CharSequence)fjmc)) {
            filepath = String.valueOf(filepath) + "\\" + fjmc;
        }
        if (!(file = new File(filepath)).exists()) {
            return "";
        }
        try {
            fileContent = FileUtils.readBytes(file);
        }
        catch (IOException e) {
            throw new BizException((IError)ErrorEnum.SERVICE_ERROR, "\u67e5\u770b\u9644\u4ef6\u4fe1\u606f\u5f02\u5e38");
        }
        String base64String = Base64.getEncoder().encodeToString(fileContent);
        base64String = base64String.replaceAll("data/image/png/base64/", "");
        return base64String;
    }

    public static String getMimeType(String filePath) {
        String mimeType = FileUtil.getMimeType((String)filePath);
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".pdf")) {
                mimeType = "application/pdf";
            } else if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".ofd")) {
                mimeType = "application/ofd";
            } else if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".jpeg")) {
                mimeType = "image/jpeg";
            } else if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".jpg")) {
                mimeType = "image/jpeg";
            } else if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".png")) {
                mimeType = "image/png";
            } else if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".gif")) {
                mimeType = "image/gif";
            }
        }
        return mimeType;
    }

    public static String getFilePath(String uploadPath, String slbh, String xmid, String fjid) {
        StringBuilder sb = new StringBuilder();
        String dateToStr = DateUtils.dateToStr(new Date(), DateUtils.DATE_FORMAT_FILE);
        sb.append(uploadPath).append(File.separatorChar).append(dateToStr).append(File.separatorChar).append(slbh).append(File.separatorChar).append(xmid).append(File.separator).append(fjid);
        return sb.toString();
    }

    public static MultipartFile getMultipartFile(File file) throws RuntimeException {
        FileInputStream inputStream = null;
        MockMultipartFile multipartFile = null;
        try {
            try {
                inputStream = new FileInputStream(file);
                multipartFile = new MockMultipartFile(file.getName(), file.getName(), Files.probeContentType(file.toPath()), (InputStream)inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u6d41\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return multipartFile;
    }

    public static byte[] convertToByteArray(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
        return outputStream.toByteArray();
    }

    public static String byteToBase64(byte[] byteArray) {
        return Base64.getEncoder().encodeToString(byteArray);
    }

    public static String encodeToBase64(InputStream inputStream) throws IOException {
        int count;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((count = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, count);
        }
        byte[] byteArray = outputStream.toByteArray();
        String base64String = Base64.getEncoder().encodeToString(byteArray);
        outputStream.close();
        return base64String;
    }

    public static MultipartFile convertMultipartFile(String base64String, String fileName) {
        byte[] imageBytes = Base64.getDecoder().decode(base64String);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
        MockMultipartFile multipartFile = null;
        try {
            multipartFile = new MockMultipartFile(fileName, fileName, "application/pdf", (InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return multipartFile;
    }

    /*
     * Loose catch block
     */
    public static byte[] images2pdf(File[] files) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                byte[] byArray;
                ByteArrayOutputStream output;
                PDDocument document;
                block40: {
                    block39: {
                        document = new PDDocument();
                        output = new ByteArrayOutputStream();
                        File[] fileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File image = fileArray[n2];
                            try {
                                Throwable throwable2 = null;
                                Object var10_16 = null;
                                try (FileInputStream input = new FileInputStream(image);){
                                    BufferedImage bufferedImage = ImageIO.read(input);
                                    float width = bufferedImage.getWidth();
                                    float height = bufferedImage.getHeight();
                                    PDPage page = new PDPage(new PDRectangle(width, height));
                                    document.addPage(page);
                                    PDImageXObject pdImageXobject = PDImageXObject.createFromFileByContent((File)image, (PDDocument)document);
                                    Throwable throwable3 = null;
                                    Object var18_26 = null;
                                    try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                                        contentStream.drawImage(pdImageXobject, 0.0f, 0.0f);
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable3 == null) {
                                            throwable3 = throwable4;
                                        } else if (throwable3 != throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                        throw throwable3;
                                    }
                                }
                                catch (Throwable throwable5) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable5;
                                    } else if (throwable2 != throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (Exception e) {
                                logger.error("\u56fe\u7247\u8f6cpdf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Throwable)e);
                            }
                            ++n2;
                        }
                        document.save((OutputStream)output);
                        byArray = output.toByteArray();
                        if (output == null) break block39;
                        output.close();
                    }
                    if (document == null) break block40;
                    document.close();
                }
                return byArray;
                {
                    catch (Throwable throwable6) {
                        try {
                            if (output != null) {
                                output.close();
                            }
                            throw throwable6;
                        }
                        catch (Throwable throwable7) {
                            if (throwable == null) {
                                throwable = throwable7;
                            } else if (throwable != throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                            if (document != null) {
                                document.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("\u56fe\u7247\u8f6cpdf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Throwable)e);
            return null;
        }
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return "";
        }
        int lastDotIndex = fileName.lastIndexOf(".");
        if (lastDotIndex == -1 || lastDotIndex == fileName.length() - 1) {
            return "";
        }
        return fileName.substring(lastDotIndex + 1);
    }

    public static boolean renameFile(String filePath, String newName) {
        File oldFile = new File(filePath);
        if (!oldFile.exists()) {
            return false;
        }
        String parentDir = oldFile.getParent();
        String fileExtension = FileUtils.getFileExtension(oldFile.getName());
        String newFilePath = String.valueOf(parentDir) + File.separator + newName + "." + fileExtension;
        File newFile = new File(newFilePath);
        return oldFile.renameTo(newFile);
    }

    public static String MultipartFileToString(MultipartFile multipartFile) {
        StringBuilder txtResult = new StringBuilder();
        try {
            String lineTxt;
            InputStreamReader isr = new InputStreamReader(multipartFile.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);
            while ((lineTxt = br.readLine()) != null) {
                txtResult.append(lineTxt);
            }
            isr.close();
            br.close();
            return txtResult.toString();
        }
        catch (IOException e) {
            logger.error("MultipartFileToString", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] image2byte(String path) {
        byte[] data = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream input = new FileInputStream(path);
                try {
                    try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                        int numBytesRead;
                        byte[] buf = new byte[8192];
                        while ((numBytesRead = input.read(buf)) != -1) {
                            output.write(buf, 0, numBytesRead);
                        }
                        data = output.toByteArray();
                    }
                    if (input == null) return data;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (input == null) throw throwable;
                    input.close();
                    throw throwable;
                }
                input.close();
                return data;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("image2byte", (Throwable)e);
        }
        return data;
    }

    public static File base64ToFile(String base64Str) {
        File outputFile;
        logger.info("base64\u5206\u5757\u8f6c\u6362\u5f00\u59cb\uff0c\u65f6\u95f4\uff1a{}", (Object)DateUtils.dateToStr(new Date()));
        try {
            outputFile = File.createTempFile("temp", ".zip");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                int length = base64Str.length();
                int offset = 0;
                while (offset < length) {
                    int end = Math.min(offset + 0x100000, length);
                    String base64Chunk = base64Str.substring(offset, end);
                    byte[] dataChunk = Base64.getDecoder().decode(base64Chunk);
                    fos.write(dataChunk);
                    offset = end;
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.info("base64\u5206\u5757\u8f6c\u6362\u7ed3\u675f\uff0c\u65f6\u95f4\uff1a{}", (Object)DateUtils.dateToStr(new Date()));
        return outputFile;
    }

    public static byte[] getCombinePdf(List<byte[]> bytes) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document();
        try {
            PdfCopy copy = new PdfCopy(document, (OutputStream)byteArrayOutputStream);
            document.open();
            for (byte[] bs : bytes) {
                PdfReader reader = new PdfReader(bs);
                int pageTotal = reader.getNumberOfPages();
                int pageNo = 1;
                while (pageNo <= pageTotal) {
                    document.newPage();
                    PdfImportedPage page = copy.getImportedPage(reader, pageNo);
                    copy.addPage(page);
                    ++pageNo;
                }
                reader.close();
            }
            document.close();
            byte[] pdfs = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            copy.close();
            return pdfs;
        }
        catch (Exception e) {
            logger.error("pdf\u6587\u4ef6\u5408\u5e76\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            return null;
        }
    }

    public static void hbpdf(List<String> pdfFiles) {
        String filePath;
        block25: {
            Document document = null;
            FileOutputStream fileOutputStream = null;
            PdfReader pdfReader = null;
            filePath = StringUtils.replace((String)pdfFiles.get(0), (String)".pdf", (String)"1.pdf");
            try {
                try {
                    pdfReader = new PdfReader(pdfFiles.get(0));
                    document = new Document(pdfReader.getPageSize(1));
                    fileOutputStream = new FileOutputStream(filePath);
                    PdfCopy copy = new PdfCopy(document, (OutputStream)fileOutputStream);
                    document.open();
                    for (String pdfFile : pdfFiles) {
                        PdfReader reader = new PdfReader(pdfFile);
                        int i = 1;
                        while (i <= reader.getNumberOfPages()) {
                            document.newPage();
                            copy.addPage(copy.getImportedPage(reader, i));
                            ++i;
                        }
                        reader.close();
                    }
                    copy.close();
                }
                catch (Exception copy) {
                    if (pdfReader != null) {
                        pdfReader.close();
                    }
                    if (document != null) {
                        document.close();
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (pdfReader != null) {
                    pdfReader.close();
                }
                if (document != null) {
                    document.close();
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (pdfReader != null) {
                pdfReader.close();
            }
            if (document != null) {
                document.close();
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            FileUtils.copyFile(new File(filePath), new File(pdfFiles.get(0)));
            boolean delete = new File(filePath).delete();
            if (!delete) {
                logger.info("Failed to delete file: " + filePath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void copyFile(File source, File target) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream in = new FileInputStream(source);
            try {
                try (FileOutputStream out = new FileOutputStream(target);){
                    int length;
                    byte[] buffer = new byte[8192];
                    while ((length = ((InputStream)in).read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, length);
                    }
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static String mergePdfs(List<String> base64Pdfs) throws IOException {
        PDFMergerUtility mergerUtility = new PDFMergerUtility();
        for (String base64Pdf : base64Pdfs) {
            byte[] pdfBytes = Base64.getDecoder().decode(base64Pdf);
            Throwable throwable = null;
            Object var6_9 = null;
            try (PDDocument document = PDDocument.load((InputStream)new ByteArrayInputStream(pdfBytes));){
                mergerUtility.addSource((InputStream)new ByteArrayInputStream(pdfBytes));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            mergerUtility.setDestinationStream((OutputStream)outputStream);
            mergerUtility.mergeDocuments(null);
            byte[] mergedPdfBytes = outputStream.toByteArray();
            return Base64.getEncoder().encodeToString(mergedPdfBytes);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] readBytes(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void decoderByteFile(byte[] bytes, String targetPath, String catalogue) {
        String tempPath;
        boolean pdf;
        block31: {
            FilterOutputStream bos = null;
            FileOutputStream fos = null;
            if (StringUtils.isNotBlank((CharSequence)catalogue) && catalogue.contains(".pdf")) {
                catalogue = catalogue.substring(0, catalogue.lastIndexOf(".pdf"));
            }
            File file = null;
            pdf = targetPath.endsWith(".pdf") && AppConfig.getBooleanProperty((String)"whole.writetopdf.rename", (boolean)false);
            tempPath = null;
            try {
                try {
                    File fileF = new File(targetPath);
                    if (fileF.exists()) {
                        fileF.delete();
                    }
                    if (pdf) {
                        tempPath = String.valueOf(targetPath.substring(0, targetPath.lastIndexOf(".pdf"))) + ".txt";
                        File dir = new File(catalogue);
                        if (!dir.exists() && !dir.isDirectory()) {
                            dir.mkdirs();
                        }
                        if ((file = new File(tempPath)).exists()) {
                            file.delete();
                        }
                        fos = new FileOutputStream(file);
                        bos = new BufferedOutputStream(fos);
                        bos.write(bytes);
                    } else {
                        File dir = new File(catalogue);
                        if (!dir.exists() && !dir.isDirectory()) {
                            dir.mkdirs();
                        }
                        file = new File(targetPath);
                        fos = new FileOutputStream(file);
                        bos = new BufferedOutputStream(fos);
                        bos.write(bytes);
                    }
                }
                catch (Exception e) {
                    logger.error("\u6587\u4ef6\u4fdd\u5b58\u51fa\u9519{}", (Object)e.getMessage());
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e2) {
                            logger.error("IO\u5173\u95ed\u5f02\u5e38{}", (Object)e2.getMessage());
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e3) {
                            logger.error("IO\u5173\u95ed\u5f02\u5e38{}", (Object)e3.getMessage());
                        }
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        logger.error("IO\u5173\u95ed\u5f02\u5e38{}", (Object)e.getMessage());
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        logger.error("IO\u5173\u95ed\u5f02\u5e38{}", (Object)e.getMessage());
                    }
                }
                throw throwable;
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error("IO\u5173\u95ed\u5f02\u5e38{}", (Object)e.getMessage());
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error("IO\u5173\u95ed\u5f02\u5e38{}", (Object)e.getMessage());
                }
            }
        }
        if (pdf) {
            File empFile = new File(tempPath);
            empFile.renameTo(new File(targetPath));
            empFile.deleteOnExit();
        }
    }
}

