/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Util {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String ENCODING_ALGORITHM = "MD5";
    private static String characterEncoding;

    public static String encode(String encyptContent) {
        if (encyptContent == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ENCODING_ALGORITHM);
            messageDigest.update(encyptContent.getBytes());
            byte[] digest = messageDigest.digest();
            return Md5Util.getFormattedText(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
    }

    public static String encode(byte[] bytes) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ENCODING_ALGORITHM);
            messageDigest.update(bytes);
            byte[] digest = messageDigest.digest();
            return Md5Util.getFormattedText(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
    }

    private static String getFormattedText(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte aByte = byArray[n2];
            buf.append(HEX_DIGITS[aByte >> 4 & 0xF]);
            buf.append(HEX_DIGITS[aByte & 0xF]);
            ++n2;
        }
        return buf.toString();
    }
}

