/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.bean;

import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ObjectUtils;

public class BeanConvertUtil {
    public static final Logger logger = LoggerFactory.getLogger(BeanConvertUtil.class);

    public static <T> T copy(Object src, Class<T> targetType) {
        T target = null;
        try {
            target = targetType.newInstance();
            BeanWrapperImpl targetBean = new BeanWrapperImpl(target);
            BeanMap srcBean = new BeanMap(src);
            for (Object key : srcBean.keySet()) {
                String srcPropertyName = "" + key;
                Object srcPropertyVal = srcBean.get(key);
                Class srcPropertyType = srcBean.getType(srcPropertyName);
                Class targetPropertyType = targetBean.getPropertyType(srcPropertyName);
                if ("class".equals(srcPropertyName) || targetPropertyType == null) continue;
                if (srcPropertyType == targetPropertyType) {
                    targetBean.setPropertyValue(srcPropertyName, srcPropertyVal);
                    continue;
                }
                if (srcPropertyVal == null) continue;
                Object targetPropertyVal = targetPropertyType.newInstance();
                BeanWrapperImpl targetPropertyBean = new BeanWrapperImpl(targetPropertyVal);
                BeanMap srcPropertyBean = new BeanMap(srcPropertyVal);
                for (Object srcPropertyBeanKey : srcPropertyBean.keySet()) {
                    String srcPropertyBeanPropertyName = "" + srcPropertyBeanKey;
                    Object srcPropertyBeanPropertyVal = srcPropertyBean.get(srcPropertyBeanKey);
                    Class srcPropertyBeanPropertyType = srcPropertyBean.getType(srcPropertyBeanPropertyName);
                    Class targetPropertyBeanPropertyType = targetPropertyBean.getPropertyType(srcPropertyBeanPropertyName);
                    if ("class".equals(srcPropertyBeanPropertyName) || targetPropertyBeanPropertyType == null || srcPropertyBeanPropertyType != targetPropertyBeanPropertyType) continue;
                    targetPropertyBean.setPropertyValue(srcPropertyBeanPropertyName, srcPropertyBeanPropertyVal);
                }
                targetBean.setPropertyValue(srcPropertyName, targetPropertyBean.getWrappedInstance());
            }
        }
        catch (Exception e) {
            logger.error("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return target;
    }

    public static <T> List<T> copyList(List srcList, Class<T> targetType) {
        ArrayList<T> newList = new ArrayList<T>();
        for (Object entity : srcList) {
            newList.add(BeanConvertUtil.copy(entity, targetType));
        }
        return newList;
    }

    public static Object convertMap(Map map, Class type) {
        Object obj = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            obj = type.newInstance();
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                String propertyName = descriptor.getName();
                if (map.containsKey(propertyName)) {
                    Object value = null;
                    try {
                        value = map.get(propertyName);
                        if ("".equals(value)) {
                            value = null;
                        }
                        Object[] args = new Object[]{value};
                        descriptor.getWriteMethod().invoke(obj, args);
                    }
                    catch (InvocationTargetException e) {
                        logger.error("bean\u8f6c\u6362\u5de5\u5177\u7c7b\uff0cmap\u8f6cbean\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        catch (IntrospectionException | IllegalAccessException | InstantiationException e) {
            logger.error("bean\u8f6c\u6362\u5de5\u5177\u7c7b\uff0cmap\u8f6cbean\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
        }
        return obj;
    }

    public static Map convertBean(Object bean) {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                String propertyName = descriptor.getName();
                if (!"class".equals(propertyName)) {
                    Method readMethod = descriptor.getReadMethod();
                    Object result = readMethod.invoke(bean, new Object[0]);
                    if (result != null) {
                        if (result instanceof String) {
                            if ("zl".equals(propertyName)) {
                                returnMap.put(propertyName, result.toString());
                            } else {
                                returnMap.put(propertyName, StringUtil.xssEncode(result.toString()));
                            }
                        } else {
                            returnMap.put(propertyName, result);
                        }
                    } else {
                        returnMap.put(propertyName, null);
                    }
                }
                ++n2;
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            logger.error("bean\u8f6c\u6362\u5de5\u5177\u7c7b\uff0cbean\u8f6cmap\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
        }
        return returnMap;
    }

    public static <T> T getBeanByJsonObj(Object json, Class<T> tClass) {
        Object t = null;
        try {
            t = json instanceof String ? JSON.parseObject((String)json.toString(), tClass) : JSON.parseObject((String)JSON.toJSONString((Object)json), tClass);
        }
        catch (Exception e) {
            logger.error("Bean\u8f6c\u6362\u5de5\u5177\u7c7bgetBeanByJsonObj\u65b9\u6cd5\u8f6c\u6362\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
        }
        return (T)t;
    }

    public static <T> List<T> getBeanListByJsonArray(Object obj, Class<T> tClass) {
        List t = null;
        try {
            t = obj instanceof String ? JSON.parseArray((String)obj.toString(), tClass) : JSON.parseArray((String)JSON.toJSONString((Object)obj), tClass);
        }
        catch (Exception var4) {
            logger.error("Bean\u8f6c\u6362\u5de5\u5177\u7c7bgetBeanListByJsonArray\u65b9\u6cd5\u8f6c\u6362\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)var4);
        }
        return t;
    }

    public static <T> void nullToEmpty(T bean) {
        Field[] field;
        Field[] fieldArray = field = bean.getClass().getDeclaredFields();
        int n = field.length;
        int n2 = 0;
        while (n2 < n) {
            Field item = fieldArray[n2];
            String name = item.getName();
            name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
            String type = item.getGenericType().toString();
            if ("class java.lang.String".equals(type)) {
                try {
                    Method mGet = bean.getClass().getMethod("get" + name, new Class[0]);
                    String value = (String)mGet.invoke(bean, new Object[0]);
                    if (value == null || value.isEmpty()) {
                        Method mSet = bean.getClass().getMethod("set" + name, String.class);
                        mSet.invoke(bean, new String(""));
                    }
                }
                catch (Exception e) {
                    logger.error("Bean\u8f6c\u6362\u5de5\u5177\u7c7bnullToEmpty\u65b9\u6cd5\u8f6c\u6362\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
                }
            }
            ++n2;
        }
    }

    public static <T> void removeThousandth(T bean) {
        Field[] fields;
        Field[] fieldArray = fields = ReflectUtil.getFields(bean.getClass());
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!ModifierUtil.isStatic((Field)field)) {
                Double.class.equals(field.getType());
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean allFieldIsNull(Object o, String ignoreField) {
        try {
            Field[] fieldArray = o.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (true) {
                Object object;
                if (n2 >= n) {
                    return false;
                }
                Field field = fieldArray[n2];
                field.setAccessible(true);
                if (!StringUtils.equals((CharSequence)field.getName(), (CharSequence)ignoreField) && !StringUtils.equals((CharSequence)field.getName(), (CharSequence)"serialVersionUID") && (object = field.get(o)) instanceof CharSequence && !ObjectUtils.isEmpty((Object)object)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public static void setProperty(Object targetObject, Object sourceObject, String propertyName) {
        try {
            String setMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            String getMethodName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            Method setMethod = targetObject.getClass().getMethod(setMethodName, String.class);
            Method getMethod = sourceObject.getClass().getMethod(getMethodName, new Class[0]);
            if (setMethod != null && getMethod != null) {
                String propertyValue = (String)getMethod.invoke(sourceObject, new Object[0]);
                setMethod.invoke(targetObject, propertyValue);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("\u53cd\u5c04\u9519\u8bef", (Throwable)e);
        }
    }
}

