/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.config;

import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.string.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private final String body;
    private final String customContentType;
    private static final Logger logger = LoggerFactory.getLogger(RequestWrapper.class);

    public RequestWrapper(HttpServletRequest request) {
        StringBuilder stringBuilder;
        block19: {
            super(request);
            this.customContentType = "application/json;charset=UTF-8";
            stringBuilder = new StringBuilder();
            ServletInputStream inputStream = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    inputStream = request.getInputStream();
                    if (inputStream != null) {
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                        char[] charBuffer = new char[128];
                        int bytesRead = -1;
                        while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                            stringBuilder.append(charBuffer, 0, bytesRead);
                        }
                    }
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage());
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block19;
                    }
                    catch (IOException ex2) {
                        logger.error("RequestWrapper --> \u6d41\u5173\u95ed\u5f02\u5e38\uff1a" + ex2.getMessage());
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("RequestWrapper --> \u6d41\u5173\u95ed\u5f02\u5e38\uff1a" + ex.getMessage());
                }
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                logger.error("RequestWrapper --> \u6d41\u5173\u95ed\u5f02\u5e38\uff1a" + ex.getMessage());
            }
        }
        String uale = stringBuilder.toString();
        this.body = Sm2lib.decode(uale);
    }

    public String getContentType() {
        return StringUtils.isNotBlank((CharSequence)this.customContentType) ? this.customContentType : super.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        String encodeBody = this.xssEncode(this.body);
        if (StringUtils.isBlank((CharSequence)encodeBody)) {
            return null;
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(encodeBody.getBytes(StandardCharsets.UTF_8));
        ServletInputStream servletInputStream = new ServletInputStream(){

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener listener) {
            }
        };
        return servletInputStream;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value != null) {
            value = this.xssEncode(value);
        }
        return value;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value != null) {
            value = this.xssEncode(value);
        }
        return value;
    }

    private String xssEncode(String body) {
        if (body == null || body.isEmpty()) {
            return body;
        }
        if (!StringUtil.isJson(body)) {
            return StringEscapeUtils.escapeHtml4((String)body);
        }
        HashMap hashMap = BeanConvertUtil.getBeanByJsonObj(body, HashMap.class);
        this.foreachMap(hashMap);
        return JSON.toJSONString((Object)hashMap);
    }

    private void foreachMap(HashMap<String, Object> hashMap) {
        if (hashMap != null) {
            for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    entry.setValue(StringEscapeUtils.escapeHtml4((String)((String)value)));
                    continue;
                }
                if (!(value instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)value;
                for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                    if (jsonEntry.getValue() instanceof JSONArray) continue;
                    jsonEntry.setValue(StringEscapeUtils.escapeHtml4((String)jsonEntry.getValue().toString()));
                }
            }
        }
    }
}

