/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.aop;

import cn.gtmap.hlw.core.annotation.UserAuthFilter;
import cn.gtmap.hlw.core.base.UserInfo;
import cn.gtmap.hlw.core.dto.filter.UserAuthFilterResultDTO;
import cn.gtmap.hlw.core.util.session.SessionUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FilterResultAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FilterResultAspect.class);
    private static final Set<Class<?>> WRAPPERTYPES = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class, String.class));

    @AfterReturning(pointcut="@annotation(cn.gtmap.hlw.core.annotation.FilterResult)", returning="result")
    public void filter(JoinPoint joinPoint, Object result) {
        List resultList;
        if (result instanceof List && CollectionUtils.isNotEmpty((Collection)(resultList = (List)result))) {
            resultList.removeIf(item -> !this.filterResultResolver(item));
        }
    }

    private UserAuthFilterResultDTO userAuthFilter(Object item, Field field) throws IllegalAccessException {
        boolean isNeedFilterFlag = false;
        boolean isChekFlag = true;
        UserInfo user = SessionUtil.getUser();
        if (user != null && field.isAnnotationPresent(UserAuthFilter.class)) {
            UserAuthFilter userAuthFilter = field.getAnnotation(UserAuthFilter.class);
            ArrayList roles = Lists.newArrayList((Object[])userAuthFilter.roles().split(","));
            String value = String.valueOf(field.get(item));
            if (CollectionUtils.isNotEmpty((Collection)roles) && roles.contains(user.getRoleId())) {
                isNeedFilterFlag = true;
                isChekFlag = StringUtils.isNotBlank((CharSequence)value) && StringUtils.equalsAny((CharSequence)value, (CharSequence[])new CharSequence[]{user.getUserZjid(), user.getOrgTyxydm()});
            }
        }
        UserAuthFilterResultDTO userAuthFilterResultDTO = new UserAuthFilterResultDTO();
        userAuthFilterResultDTO.setIsNeedFilterFlag(isNeedFilterFlag);
        userAuthFilterResultDTO.setIsChekFlag(isChekFlag);
        return userAuthFilterResultDTO;
    }

    private void shouldKeep(Object item, Set<Object> visited, List<UserAuthFilterResultDTO> userAuthlist) throws IllegalAccessException {
        Field[] fields;
        if (item == null || visited.contains(item)) {
            return;
        }
        visited.add(item);
        Field[] fieldArray = fields = item.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            UserAuthFilterResultDTO userAuthFilterResultDTO = this.userAuthFilter(item, field);
            userAuthlist.add(userAuthFilterResultDTO);
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection collection = (Collection)field.get(item);
                if (collection != null) {
                    for (Object element : collection) {
                        this.shouldKeep(element, visited, userAuthlist);
                    }
                }
            } else if (!field.getType().isPrimitive() && !WRAPPERTYPES.contains(field.getType())) {
                Object nestedObject = field.get(item);
                this.shouldKeep(nestedObject, visited, userAuthlist);
            }
            ++n2;
        }
    }

    private boolean filterResultResolver(Object item) {
        boolean flag = true;
        ArrayList<UserAuthFilterResultDTO> userAuthlist = new ArrayList<UserAuthFilterResultDTO>();
        try {
            this.shouldKeep(item, new HashSet<Object>(), userAuthlist);
        }
        catch (IllegalAccessException e) {
            log.error("Error during filtering: ", (Throwable)e);
            return false;
        }
        if (CollectionUtils.isNotEmpty(userAuthlist)) {
            for (UserAuthFilterResultDTO userAuthFilterResultDTO : userAuthlist) {
                if (userAuthFilterResultDTO.getIsNeedFilterFlag().booleanValue()) {
                    flag = false;
                }
                if (!userAuthFilterResultDTO.getIsNeedFilterFlag().booleanValue() || !userAuthFilterResultDTO.getIsChekFlag().booleanValue()) continue;
                return true;
            }
        }
        return flag;
    }
}

