/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.constant.redis;

import cn.gtmap.hlw.core.dto.workflow.query.WorkFlowQueryDTO;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class RedisHotDataKeyConstant {
    public static final String ROUTES_ROLE_GUID = "routes_role_guid:";
    public static final String DETAIL_ROLE_GUID = "detail_role_guid:";
    public static final String APP_DETAIL_ROLE_GUID = "app_detail_role_guid:";
    public static final String APP_SERVICE_ROLE_GUID = "app_service_role_guid:";
    public static final String APP_MINE_ROLE_GUID = "app_mine_role_guid:";
    public static final String WORK_FLOW_QUERY = "work_flow_query:";
    public static final String NEWS_ROUTES_CACHE_KEY = "news_routes:";

    public static String getRoutesRoleGuid(String roleid, String guid) {
        return ROUTES_ROLE_GUID + roleid + guid;
    }

    public static String getDetailRoleGuid(String roleid, String guid) {
        return DETAIL_ROLE_GUID + roleid + guid;
    }

    public static String getAppDetailRoleGuid(String roleid, String guid) {
        return APP_DETAIL_ROLE_GUID + roleid + guid;
    }

    public static String getAppServiceRoleGuid(String roleid, String guid) {
        return APP_SERVICE_ROLE_GUID + roleid + guid;
    }

    public static String getAppMineRoleGuid(String roleid, String guid) {
        return APP_MINE_ROLE_GUID + roleid + guid;
    }

    public static String getNewsRoutesCacheKey(String type, List<String> typeList) {
        return NEWS_ROUTES_CACHE_KEY + type + "_" + String.join((CharSequence)"_", typeList);
    }

    public static String getWorkFlowQuery(WorkFlowQueryDTO workFlowQueryDTO) {
        if (workFlowQueryDTO != null) {
            return WORK_FLOW_QUERY + workFlowQueryDTO.getSqlxdm() + workFlowQueryDTO.getRoleId() + workFlowQueryDTO.getClientType() + workFlowQueryDTO.getType() + workFlowQueryDTO.getFunctionMenuId();
        }
        return WORK_FLOW_QUERY + UUID.randomUUID();
    }

    public static String getWorkFlowQueryDelete(String sqlx) {
        if (StringUtils.isNotBlank((CharSequence)sqlx)) {
            return WORK_FLOW_QUERY + sqlx;
        }
        return WORK_FLOW_QUERY;
    }

    public static String getOrderDateOrgid(String orgid) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        String currentDate = dateFormat.format(calendar.getTime());
        return "order_date_orgid:" + currentDate + orgid;
    }

    public static String getOrderDateOrgidDelete() {
        return "order_date_orgid:";
    }
}

