package cn.gtmap.hlw.core.enums.sw;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/31
 * @description 审核状态
 */
@Getter
@AllArgsConstructor
public enum ShztEnum {
    /**
     * 审核状态 - 外部数据接收完成
     */
    WBSJJSWC("00", "外部数据接收完成"),
    /**
     * 审核状态 - 数据校检不通过
     */
    SJJYBTG("01", "数据校检不通过"),
    /**
     * 审核状态 - 婚姻比对不通过
     */
    HYDBBTG("02", "婚姻比对不通过"),
    /**
     * 审核状态 - 家庭成员比对不通过
     */
    JTCYDBBTG("03", "家庭成员比对不通过"),
    /**
     * 审核状态 - 住房套次比对不通过
     */
    ZFTCDBBTG("04", "住房套次比对不通过"),
    /**
     * 审核状态 - 提交流程启动
     */
    TJLCQD("10", "提交流程启动"),
    /**
     * 审核状态 - 审核通过
     */
    SHTG("11", "审核通过"),
    /**
     * 审核状态 - 存量房交易纳税评估中
     */
    CLFJYNSPGZ("12", "存量房交易纳税评估中"),
    /**
     * 审核状态 - 存量房交易纳税评估通过
     */
    NSPGTG("13", "存量房交易纳税评估通过"),
    /**
     * 审核状态 - 审核不通过
     */
    SHBTG("14", "审核不通过"),
    /**
     * 审核状态 - 存量房交易纳税评估不通过
     */
    NSPGBTG("15", "存量房交易纳税评估不通过"),
    /**
     * 审核状态 - 冻结
     */
    DJ("20", "冻结"),
    /**
     * 审核状态 - 作废
     */
    ZF("30", "作废"),
    /**
     * 审核状态 - 完结审核通过
     */
    WJSHTG("40", "完结审核通过"),
    /**
     * 审核状态 - 完结审核不通过
     */
    WJSHBTG("50", "完结审核不通过"),
    /**
     * 审核状态 - 申报信息确认单待打印
     */
    QRDDDY("60", "申报信息确认单待打印"),
    /**
     * 审核状态 - 申报成功
     */
    SBCG("70", "申报成功"),
    /**
     * 审核状态 - 申报失败
     */
    SBSB("80", "申报失败"),
    /**
     * 审核状态 - 缴款完成
     */
    JKWC("90", "缴款完成");

    private String code;

    private String msg;
}
