package cn.gtmap.hlw.coredk.dto.olcommon.cqcx;

import cn.gtmap.hlw.core.model.CrossRiver.DyYwrEntity;
import lombok.Data;

import java.util.List;


/**
 * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
 * @version 1.0 2025/6/19
 * @description 抵押首次产权查询 结果
 */
@Data
public class OlDyscCqcxRespDTO {

    /**
     * 行政区域代码
     */
    private String xzqydm;

    /**
     * 行政区域名称
     */
    private String xzqymc;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 查封状态
     */
    private String cfzt;

    /**
     * 抵押状态
     */
    private String dyzt;

    /**
     * 居住权状态
     */
    private String jzzt;

    /**
     * 证书项目ID
     */
    private String zsxmid;



    /**
     * 权籍坐落
     */
    private String qjzl;

    /**
     * 证书来源（2：新证书3：老证书）
     */
    private String zsly;

    /**
     * 不动产单元编号
     */
    private String bdcdybh;

    /**
     * 面积
     */
    private String mj;

    /**
     * 页面展示用途
     */
    private String yt;

    /**
     * 规划用途名称
     */
    private String ghytmc;

    /**
     * 宗地用途代码
     */
    private String zdytdm;

    /**
     * 宗地用途
     */
    private String zdytmc;

    /**
     * 行政区划数字代码
     */
    private String xzqhszdm;

    /**
     * 所在层
     */
    private String szc;

    /**
     * 总层数
     */
    private String zcs;

    /**
     * 登记时间
     */
    private String djsj;

    /**
     * 房屋结构
     */
    private String fwjg;

    /**
     * 房屋结构名称
     */
    private String fwjgmc;

    /**
     * 房屋性质
     */
    private String fwxz;

    /**
     * 房屋性质名称
     */
    private String fwxzmc;

    /**
     * 房屋类型
     */
    private String fwlx;

    /**
     * 房屋类型名称
     */
    private String fwlxmc;

    /**
     * 规划用途
     */
    private String ghyt;

    /**
     * 竣工时间
     */
    private String jgsj;

    /**
     * 建成年份
     */
    private String jcnf;

    /**
     * 权利类型代码
     */
    private String qllxdm;

    /**
     * 权利类型名称
     */
    private String qllxmc;

    /**
     * 附记
     */
    private String fj;

    /**
     * 房间号
     */
    private String fjh;

    /**
     * 栋号
     */
    private String dh;

    /**
     * 登记原因
     */
    private String djyy;

    /**
     * 套内面积
     */
    private String tnmj;

    /**
     * 申请事由
     */
    private String sqsy;

    /**
     * 申请事由名称
     */
    private String sqsymc;

    /**
     * 土地使用权面积(登记3.0)
     */
    private String tdsyqmj;

    /**
     * 限制信息 产权调用5.7.4	根据BDCDYH查询限制权利
     */
//    private ResponseXzqlMainEntity xzxx;

    /**
     * 不动产类型代码 5.2	表bdc_zd_bdclx 不动产类型字典表 放代码(2.0)
     */
    private String bdclxdm;

    /**
     * 不动产类型名称 5.2	表bdc_zd_bdclx 不动产类型字典表 放名称(2.0)
     */
    private String bdclxmc;

    /**
     * 宗地面积
     */
    private String zdmj;

    /**
     * 宗地权利性质代码
     */
    private String zdqlxzdm;

    /**
     * 宗地权利性质名称
     */
    private String zdqlxzmc;


    /**
     * 实际层
     */
    private String sjc;

    /**
     * 单元号
     */
    private String dyh;

    /**
     * 宗地/宗海权利性质代码
     */
    private String zdzhqlxzdm;

    /**
     * 宗地/宗海权利性质名称
     */
    private String zdzhqlxzmc;

    /**
     * 行政区代码
     */
    private String xzqdm;

    /**
     * 宗地宗海面积
     */
    private String zdzhmj;

    //25	土地使用开始期限	tdsyksqx	字符串		例：2021-09-11
    private String tdsyksqx;
    //26	土地使用结束期限	tdsyjsqx	字符串		例：2021-09-11
    private String tdsyjsqx;
    //42土地分摊面积
    private String tdftmj;
    //43土地独用面积
    private String tddymj;
    //44土地权利起始时间
    private String tdqlqssj;
    //45土地权利结束时间
    private String tdqljssj;

    /**
     * 权籍关联代码
     */
    private String qjgldm;

    private String ftjzmj;
    /**
     * 附属设施
     */
    private String fsss;


    /**
     * 产权人信息
     */
    private List<DyYwrEntity> qlr;

    /**
     * 关联土地证
     */
    private List<OlDyscGltdzxxRespDTO> gltdzxx;

}
