package cn.gtmap.hlw.coredk.dto.hlwweb.third.ahDzzz;

import lombok.Data;

/**
 * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
 * @version 1.0 2025/8/21
 * @description 线上请求授权入参
 */
@Data
public class ReqAuthOnlineDto {

    /**
     * 办事主体名称（权利人名称）
     */
    private String handleSubName;

    /**
     * 办事主体证件号码（权利人证件号）
     */
    private String handleSubNo;

    /**
     * 办理业务（申请类型名称）
     */
    private String handleBusiness;

    /**
     * 类型编码，多个类型使用英文逗号分隔
     */
    private String typeCode;

    /**
     * 数据使用范围：1：证照材料信息，2：证照材料文件，3：证照照面信息
     */
    private String dataUseRange;

    /**
     * 办理类型：1：自办，2：代办
     */
    private String handleType;

    /**
     * 使用终端：1：PC，2:APP
     */
    private String useTerminal;

    /**
     * 默认1：优先使用电子证照，无证照查询材料；2：仅使用电子证照；3：仅使用电子材料
     */
    private String queryType;


    /*用户登录token（个人代办法人时必填）*/
    private String loginToken;
    /*代办主体名称（个人代办法人时必填，法人自办必填）*/
    private String agencySubName;
    /*代办主体名称（个人代办法人时必填，法人自办必填）*/
    private String agencySubNo;
}
