package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.WctJySfssxx;

import java.util.List;
import java.util.Map;

/**
 * (WctJySfssxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface WctJySfssxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    WctJySfssxx get(String id);

    /**
     * 新增数据
     *
     * @param wctJySfssxx 实例对象
     * @return 影响行数
     */
    void save(WctJySfssxx wctJySfssxx);

    /**
     * 修改数据
     *
     * @param wctJySfssxx 实例对象
     * @return 影响行数
     */
    void update(WctJySfssxx wctJySfssxx);

    /**
     * 通过map查询单条数据
     *
     * @param map
     * @return 实例对象
     */
    List<WctJySfssxx> getListByMap(Map<String, Object> map);

    /**
     * 通过slbh查询数据
     *
     * @param slbh
     * @return 实例对象
     */
    List<WctJySfssxx> listBySlbh(String slbh);
    /**
     * 更新、保存
     * @param sfssxx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void saveOrUpdate(WctJySfssxx sfssxx);
    /**
     * 根据slbh、qlrlb查询
     * @param slbh
     * @param qlrlb
     * @return:cn.gtmap.hlw.domain.wct.model.WctJySfssxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    WctJySfssxx getBySlbhAndQlrlb(String slbh, String qlrlb);
}

