package cn.gtmap.hlw.core.repository;


import cn.gtmap.hlw.core.model.WctJyHsxxmx;

import java.util.List;

/**
 * (WctJyHsxxmx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface WctJyHsxxmxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    WctJyHsxxmx get(String id);

    /**
     * 新增数据
     *
     * @param wctJyHsxxmx 实例对象
     * @return 影响行数
     */
    void save(WctJyHsxxmx wctJyHsxxmx);

    /**
     * 修改数据
     *
     * @param wctJyHsxxmx 实例对象
     * @return 影响行数
     */
    void update(WctJyHsxxmx wctJyHsxxmx);

    /**
     * 批量新增数据
     *
     * @param wctJyHsxxmxList 实例对象
     * @return 影响行数
     */
    void saveBatch(List<WctJyHsxxmx> wctJyHsxxmxList);

    /**
     * 根据hsxxid删除数据
     *
     * @param hsxxid 实例对象
     * @return
     */
    void deleteByHsxxid(String hsxxid);

    /**
     * 根据hsxxid查询数据
     *
     * @param hsxxid 实例对象
     * @return
     */
    List<WctJyHsxxmx> listByHsxxid(String hsxxid);

    /**
     * 根据hsxxIdList查询数据
     *
     * @param hsxxIdList 实例对象
     * @return
     */
    List<WctJyHsxxmx> listByHsxxidList(List<String> hsxxIdList);

    /**
     * 根据ids删除数据
     *
     * @param ids 实例对象
     * @return
     */
    void deleteByIds(List<String> ids);

    /**
     * 根据hsxxidList删除数据
     *
     * @param hsxxidList 实例对象
     * @return
     */
    void deleteByHsxxidList(List<String> hsxxidList);
}

