package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyZtfwMenuRel;

import java.util.List;

/**
 * 专题服务与功能菜单关系表(GxYyZtfwMenuRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:34:59
 */
public interface GxYyZtfwMenuRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyZtfwMenuRel get(String id);

    /**
     * 新增数据
     *
     * @param gxYyZtfwMenuRel 实例对象
     * @return 影响行数
     */
    void save(GxYyZtfwMenuRel gxYyZtfwMenuRel);

    /**
     * 新增数据
     *
     * @param gxYyZtfwMenuRelList 实例对象集合
     * @return 影响行数
     */
    int batchSave(List<GxYyZtfwMenuRel> gxYyZtfwMenuRelList);

    /**
     * 删除数据
     *
     * @param ztfwId 专题服务id
     * @return 影响行数
     */
    int delete(String ztfwId);

    /**
     * 修改数据
     *
     * @param gxYyZtfwMenuRel 实例对象
     * @return 影响行数
     */
    void update(GxYyZtfwMenuRel gxYyZtfwMenuRel);

    /**
     * 根据zid得到FUNCTION_MENU_ID集合
     *
     * @param ztfwId 实例对象集合
     * @return Map<GxYyZtfw, List < String>>
     */
    List<String> getZtfwMenuRelByZtfwId(String ztfwId);
    /**
     * 根据zid得到FUNCTION_MENU_ID集合
     *
     * @param ztfwIds 实例对象集合
     * @return Map<GxYyZtfw, List < String>>
     */
    List<GxYyZtfwMenuRel> getZtfwMenuRelByZtfwIds(List<String> ztfwIds);

}

