package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyZdFj;

import java.util.List;
import java.util.Set;

/**
 * 不动产附件字典表(GxYyZdFj)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 16:38:58
 */
public interface GxYyZdFjRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param dm 主键
     * @return 实例对象
     */
    GxYyZdFj get(Integer dm);

    /**
     * 新增数据
     *
     * @param gxYyZdFj 实例对象
     * @return 影响行数
     */
    void save(GxYyZdFj gxYyZdFj);

    /**
     * 修改数据
     *
     * @param gxYyZdFj 实例对象
     * @return 影响行数
     */
    void update(GxYyZdFj gxYyZdFj);

    /**
     * 根据申请类型、登记原因查看附件
     * @param sqlxList
     * @param djyy
     * @return
     */
    List<GxYyZdFj> getZdFjListByFjywAndDjyy(List<String> sqlxList, String djyy);

    /**
     * 根据附件类型查询
     * @param fjlx 附件类型
     * @return:GxYyZdFj
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYyZdFj getByFjlx(String fjlx, String sqlx);

    /**
     * 根据附件类型查询集合
     * @param sqlxList
     * @return:GxYyZdFj
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyZdFj> getBySqlx(Set<String> sqlxList);

    /**
     * 根据sqlx集合和fjlx查询
     *
     * @param sqlxList
     * @param fjlx
     * @return:GxYyZdFj
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyZdFj getBySqlxListAndFjlx(List<String> sqlxList, String fjlx);

    /**
     * 根据sqlx获取不推送登记的附件类型集合
     *
     * @param sqlx 申请类型
     * @return:附件类型集合
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<String> getNoPushDjZdFjlxBySqlx(String sqlx, String djyy);
}

