package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyYstzzt;

import java.util.List;

/**
 * (GxYyYstzzt)表数据库访问层
 *
 * @author <a href="mailto:fenghaorui@gtmap.cn">fenghaorui</a>
 * @since 2024-03-14 11:06:49
 */
public interface GxYyYstzztRepository {


    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyYstzzt get(Integer id);

    /**
     * 新增数据
     *
     * @param gxYyYstzzt 实例对象
     * @return 影响行数
     */
    void save(GxYyYstzzt gxYyYstzzt);

    /**
     * 修改数据
     *
     * @param gxYyYstzzt 实例对象
     * @return 影响行数
     */
    void update(GxYyYstzzt gxYyYstzzt);


    /**
     * 通过ID删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int delete(Integer id);

    /**
     * 通过slbh查询数据集合
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    List<GxYyYstzzt> list(String slbh);

    /**
     * 通过sqid数组查询数据集合
     *
     * @param sqids 申请id
     * @return 实例对象
     */
    List<GxYyYstzzt> getYstzztBySqids(List<String> sqids);

    /**
     * 根据受理编号保存或更新
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    void saveOrUpdateZtBySlbh(String slbh, String sqid, String zt);

}

