package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 申请信息打印内容model
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2025-6-24 09:28
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HlwSqxxDy implements Serializable {

    /**
     * 主键
     */
    private String id;
    /**
     * 打印内容（json格式）
     */
    private String dynrJson;
    /**
     * 所属功能代码（1：申请书打印，2：税务承诺书勾选3：抵押注销证明，4：破产管理人）
     */
    private String ssgndm;
    /**
     * 申请id
     */
    private String sqid;

}

