package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 2.0, 2023/5/30
 * @description 委托信息
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyWtxx {
    //委托信息id
    private String wtxxid;
    //委托人名称
    private String wtrmc;
    //委托人名称脱敏
    private String wtrmcTm;
    //委托人证件号
    private String wtrzjh;
    //委托人证件号脱敏
    private String wtrzjhTm;
    //委托人联系电话
    private String wtrlxdh;
    //委托人联系电话脱敏
    private String wtrlxdhTm;
    //性别
    private String wtrxb;
    //不动产单元号
    private String bdcdyh;
    //坐落
    private String zl;
    //委托原因
    private String wtyy;
    //受委托人名称
    private String swtrmc;
    //受委托人名称脱敏
    private String swtrmcTm;
    //受委托人证件号
    private String swtrzjh;
    //受委托人证件号脱敏
    private String swtrzjhTm;
    //受委托人联系电话
    private String swtrlxdh;
    //受委托人联系电话脱敏
    private String swtrlxdhTm;
    //受委托人性别
    private String swtrxb;
    //委托类型
    private String wtlx;
    //委托期限
    private Integer wtqx;
    //委托时间
    private Date wtsj;
    //委托人签署状态(未签署：0,签署中：1,已签收：2)
    private String wtrqszt;
    //受委托人签署状态(未签署：0,签署中：1,已签收：2)
    private String swtrqszt;
    //房产证登记日期
    private Date fczdjrq;
    //审核状态（0未审核，1通过,2未通过）
    /**
     * 宣城业务状态说明：
     * 1.“待审核”：在线委托申请待不动产登记机构工作人员审核；
     * 2.“已撤销”：在线委托申请已由委托人自行撤销；
     * 3.“未通过”：在线委托申请预审未通过，请阅读工作人员退回意见；--配短信通知
     * 4.“待办理”：在线委托申请已审核通过，等待受托人前往线下大厅办理不动产登记业务；--配短信通知
     * 5.“受理中”：受托人已前往线下大厅，经委托的不动产登记业务已开始办理；--配短信通知
     * 6.“已登簿”：申请的登记事项已记载于不动产登记簿；
     * 7.“办结”：经委托办理的不动产登记业务已办结。
     */
    private String shzt;
    //审核信息
    private String shxx;
    //审核人名称
    private String shr;
    //审核人id
    private String shrid;
    //审核时间
    private Date shsj;
    //产权证号
    private String cqzh;
    //委托有效期，例如：2024-02-02至2024-02-10
    private String wtyxq;
    /**
     * 见证材料同步状态（1 未同步 2 已同步 3部分同步）
     */
    private String jzcltbzt;

    /**
     * 委托查询权限
     */
    private String wtcxqx;
    /**
     * 受委托人证件类型（代码）
     */
    private String swtrzjlx;
    /**
     * 委托结束日期
     */
    private Date wtjsrq;
    /**
     * 委托人视频地址
     */
    private String wtrspdz;
    /**
     * 受托人视频地址
     */
    private String strspdz;
}
