package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 申请类型节点与领域事件关系表(GxYySqlxJdxxLysjRel)表实体类BO
 *
 * @author makejava
 * @since 2023-08-08 09:55:45
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYySqlxJdxxLysjRel implements Serializable {
    private static final long serialVersionUID = 4815668708708973295L;
    private String plid;

    /**
     * 申请类型
     */
    private String sqlx;

    /**
     * 节点代码
     */
    private String jddm;

    /**
     * gx_yy_lysj表dm
     */
    private String lysjdm;

    /**
     * 事件级别（0：中断；1：忽略）
     */
    private String lysjjb;

    /**
     * 领域事件是否顺序执行（0：否，1：是）(轻易不建议同步执行)
     */
    private String lysjsftbzx;

    /**
     * 领域事件执行顺序（事件执行的顺序，如果是同步执行，顺序号填一样）
     */
    private Integer lysjzxsx;

    /**
     * 领域动作代码
     */
    private String lydzdmlist;

    /**
     * 按钮id（gx_yy_zd_an.anid）该字段如果为空表示页面初始化调用接口
     */
    private String anid;

    /**
     * 按钮名称（gx_yy_zd_an.anmc，可自定义）
     */
    private String anmc;

    /**
     * 按钮类型（gx_yy_zd_an.anlx，可自定义）
     */
    private String anlx;

    /**
     * 按钮顺序（1-99，1排在最前面，控制页面按钮排序）
     */
    private Integer ansx;
    /**
     * 按钮（前端）扩展配置（前端部分扩展配置）
     */
    private String ankzpz;

    /**
     * 方法类型(page:页面,method:方法）
     */
    private String fflx;

    /**
     * 地址
     */
    private String url;
}

