package cn.gtmap.hlw.core.enums.qlr;

import cn.gtmap.hlw.core.constant.number.NumberConstant;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 受理状态
 */
@Getter
@AllArgsConstructor
public enum RzdbEnum {
    /** 无需比对*/
    WXDB("0","无需比对"),
    /**未比对 */
    WDB("1","未比对"),
    /** 比对通过 */
    BDTG("2","比对通过"),
    /**比对未通过 */
    BDWTG("3","比对未通过"),
    /**未比对 */
    WBD("4","已比对");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (RzdbEnum xq : RzdbEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
    public static String getDzMsg(String code) {
        if(StringUtils.equalsAny(code, NumberConstant.STR_ZERO,NumberConstant.STR_ONE)){
            return RzdbEnum.WDB.getMsg();
        }else{
            return RzdbEnum.WBD.getMsg();
        }
    }

}
