package cn.gtmap.hlw.core.enums.qlr;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 权利人类型
 *
 * @author admin
 * @Date 2023-06-25
 * @Version V1.0
 */
@Getter
@AllArgsConstructor
public enum QlrTypeEnum {
    /**
     * 权利人类型-权利人
     */
    QLRLX_QLR ("1", "权利人"),

    /**
     * 权利人类型-义务人
     */
    QLRLX_YWR("2", "义务人"),

    /**
     * 权利人类型-抵押权人
     */
    QLRLX_DYQR("3", "抵押权人"),

    /**
     * 权利人类型-借款人
     */
    QLRLX_JKR("4", "借款人"),

    /**
     * 权利人类型-原抵押权人
     */
    QLRLX_YDYQR("5", "原抵押权人"),

    /**
     * 权利人类型-公积金抵押权人
     */
    QLRLX_DYQRGJJ("6", "公积金抵押权人"),
    /**
     * 权利人类型-代理人
     */
    QLRLX_DLR("7", "代理人"),
    /**
     * 权利人类型-9或空	全部
     */
    QLRLX_ALL("9", "全部"),
    /**
     * 权利人性别--男
     */
    QLRXB_BOY("1", "男"),
    /**
     * 权利人性别--女
     */
    QLRLX_GIRL("2", "女");


    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (QlrTypeEnum xq : QlrTypeEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}

