package cn.gtmap.hlw.core.dto.user.user;

import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/9/19
 * @description
 */
@Data
public class UserRegisterDTO {
    /**
     * 联系电话
     */
    private String lxdh;
    /**
     * 真实姓名
     */
    private String realName;
    /**
     * 证件号
     */
    private String userZjid;
    /**
     * 验证码
     */
    private String yzm;
    /**
     * 验证码类型  （1：手机号码验证,2:图片验证）
     */
    private String yzmlx;
    /**
     * 密码
     */
    private String userPwd;
    /**
     * 领域事件代码
     */
    private String lysjdm;
    /**
     * 注册类型
     */
    private String registerType;
    /**
     * 0代表手机端用户，1代表平台用户
     */
    private String zcly;
    /**
     * 用户id
     */
    private String userId;
    /**
     * @author <a href="mailto:liwenwu@gtmap.cn">liwenwu</a>
     * @version 2.0,
     * @param
     * @return
     * @description  身份证附件
     */
    private List<UserOcrFjxxDTO> fjList;
    /**
     * 认证成功后页面跳转地址
     */
    private String redirectUrl;
    /**
     * 认证发起来源，默认值为 BROWSER
     * BROWSER - 浏览器
     * APP - 移动端APP（传APP时，redirectUrl字段必传）
     */
    private String origin;
}
