package cn.gtmap.hlw.core.dto.third.dzzz;

import lombok.Data;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/9/2
 * @description 证照材料信息获取入参
 */
@Data
public class MaterialQueryDTO {

    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 申请id
     */
    private String sqid;
    /**
     * 认证token
     */
    private String token;
    /**
     * 查询码
     */
    private String queryCode;
    /**
     * 材料类型编码（只能填一个类型编码）
     */
    private String typeCode;
    /**
     * 窗口办理人员姓名
     */
    private String personName;
    /**
     * 窗口办理人员联系方式
     */
    private String personPhone;
    /**
     * 使用范围，不超过50字
     */
    private String userRange;
    /**
     * 使用形式：默认1优先使用电子证照，无证照查询材料；2仅使用电子证
     * 照；3仅使用电子材料
     */
    private String useForm;
    /**
     * 返回材料数量，默认3条，最大20条
     */
    private String maxNum;
    /**
     * 材料级别（B，C，D），B表示查询B级材料，C表示查询C、B级材料，D
     * 表示查询所有材料。默认是C查询C、B级材料。
     */
    private String lvl;
    /**
     * 是否请求国办接口，Y表示请求，N表示不请求，可不传该字
     */
    private String isGb;
    /**
     * 是否法人授权（Y：是，N：否）
     */
    private String isLegalAuth;
    /**
     * 办件编号（具体编码规则如下：6位区划+32位UUID）
     */
    private String thirdOrderNo;
    /**
     * 事项名称
     */
    private String itemName;
    /**
     * 事项编码
     */
    private String itemCode;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 权利人类型
     */
    private String qlrlx;


}
