package cn.gtmap.hlw.core.dto.sw.hs.kunsan;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/9/19
 * @description
 */
@Data
public class NsrxxGrid {
    /**
     * 所占份额
     */
    private String szfe2;
    /**
     * 地址
     */
    private String dz;
    /**
     * 身份证件类型代码
     */
    @ZdDzConfig(field = "sfzjzlDm", tableName = ZdDzConstant.ZD_DZ_ZJLX, dmToDm = true)
    private String sfzjzlDm;
    /**
     * 房屋套次代码
     */
    @ZdDzConfig(field = "fwtcDm", tableName = ZdDzConstant.ZD_DZ_FWTC, dmToDm = true)
    private String fwtcDm;
    /**
     * 上次取得房屋方式
     */
    @ZdDzConfig(field = "scqdFwfs", tableName = ZdDzConstant.ZD_DZ_JYFS, dmToDm = true)
    private String scqdFwfs;
    /**
     * 变动份额
     */
    private String bdfe2;
    /**
     * 转让方承受方标志
     */
    private String zrfcsfbz;
    /**
     * 国籍代码
     */
    private String gjDm;
    /**
     * 行业代码
     */
    private String hyDm;
    /**
     * 纳税人名称
     */
    private String nsrmc;
    /**
     * 主产权人标志
     */
    private String zcqrbz;
    /**
     * 联系电话
     */
    private String lxdh;
    /**
     * 身份证件号码
     */
    private String sfzjhm;
    /**
     * 购买方直系亲属标志
     */
    private String gmfzxqsbz;
    /**
     * 上次取得房屋成本
     */
    private String scqdFwcb;
    /**
     * 上次取得房屋时间
     */
    private String scqdFwsj;
    /**
     * 婚姻状态
     */
    @ZdDzConfig(field = "hyztdm", tableName = ZdDzConstant.ZD_DZ_HYZT, dmToDm = true)
    private String hyztdm;
    /**
     * 配偶姓名
     */
    private String poxm;
    /**
     * 配偶证件号码
     */
    private String pozjhm;
    /**
     * 配偶证件类型代码
     */
    @ZdDzConfig(field = "pozjlxdm", tableName = ZdDzConstant.ZD_DZ_ZJLX, dmToDm = true)
    private String pozjlxdm;
    /**
     * 转让方与承受方关系代码
     */
    private String zrfycsfgxDm;
    /**
     * 备注
     */
    private String bz;
    /**
     * 未成年子女
     */
    private List<Wcnzn> wcnzn;
}
