package cn.gtmap.hlw.core.dto.sqxx.save;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.Data;

import java.io.Serializable;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/8 9:32
 * @description 权利人家庭成员
 */
@Data
public class QlrJtcyDTO implements Serializable {
    //private Integer jtcyid;

    /**权利人ID*/
    private String qlrid;

    /**申请ID*/
    private String sqid;

    /**家庭成员名称*/
    private String jtcymc;

    /**家庭成员证件号*/
    private String jtcyzjh;

    /**与买（卖）家关系*/
    private String jtgx;

    @ZdTypeConfig(field = "jtgx",tableName = ZdTypeConstant.ZD_TYPE_JTGX,dmToMc = true)
    private String jtgxmc;

    /**脱敏字段家庭成员名称*/
    private String jtcymcTm;

    /**脱敏字段家庭成员证件号*/
    private String jtcyzjhTm;

    /**家庭成员证件种类（GX_YY_ZD_ZJLX.DM）*/
    private String jtcyzjzl;
    @ZdTypeConfig(field = "jtcyzjzl",tableName = ZdTypeConstant.ZD_TYPE_ZJLX,dmToMc = true)
    private String jtcyzjzlmc;

    /**共享标识1：共享，0：非共享*/
    private String gxbs;

    /**家庭成员婚姻状态(zd_type=HYZT)*/
    private String jtcyhyzt;

    /**唯一申报号*/
    private String wysbh;

    /**家庭成员性别 字典表1：男2：女*/
    private String jtcyxb;
    private String jtcyxbmc;

    /**家庭成员国籍代码 字典表GJ*/
    private String jtcygjdm;

    /**是否手动添加 0：否 1：是*/
    private String sfsdtj;

    /**是否查询房产信息 0：否 1：是*/
    private String sfcxfcxx;

    /**家庭成员房屋套次*/
    private String jtcyfwtc;


}
