package cn.gtmap.hlw.core.dto.exchange.push;

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/3/25
 * @description 系统推送设置
 */
@Data
public class PushXttsszDTO {
    /**
     * 主键
     */
    private String id;

    /**
     * 行政区域代码
     */
    private String xzqydm;

    /**
     * 申请类型代码，gx_yy_zd_sqlx.dm
     */
    private String sqlxdm;

    /**
     * 不动产类型代码（gx_yy_zd_type.ZD_TYPE=BDCLX）
     */
    private String bdclxdm;

    /**
     * 登记申请类型
     */
    private String djsqlxdm;

    /**
     * 登记申请类型名称
     */
    private String djsqlxmc;

    /**
     * 登记子项代码
     */
    private String djzxdm;

    /**
     * 登记子项名称
     */
    private String djzxmc;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date createDate;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date updateDate;

    /**
     * 登记是否创建项目（0:否，1:是）
     */
    private String djsfcjxm;

    /**
     * 是否产权证号验证（0:否，1:是）
     */
    private String sfcqzhyz;

    /**
     * 登记是否需要创建前验证，0不需要；1需要
     */
    private String djsfcjyz;

    /**
     * 登记是否自动转发向审核节点 0不转发 1转发
     */
    private String djsfzdzf;

    /**
     * 登记原因代码
     */
    private String djyydm;
}
