package cn.gtmap.hlw.core.dao.user;


import cn.gtmap.hlw.core.model.GxYyUserRoleRel;

import java.util.List;

/**
 * (GxYyUserRoleRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface GxYyUserRoleRelDao {


    /**
     * 获取数据
     *
     * @param userId 用户id
     * @return 影响行数
     */
    List<GxYyUserRoleRel> getGxYyUserRoleRelsByUserId(String userId);

    /**
     * 获取数据
     *
     * @param userIdList 用户id
     * @return 影响行数
     */
    List<GxYyUserRoleRel> getByuserIdList(List<String> userIdList);

    /**
     * 获取数据
     *
     * @param roleIdList 角色id
     * @return 影响行数
     */
    List<GxYyUserRoleRel> getByRoleIdList(List<String> roleIdList);

    /**
     * 删除数据
     *
     * @param roleId
     * @return 影响行数
     */
    void deleteByRoleId(String roleId);

    /**
     * 删除数据
     *
     * @param userId
     * @return 影响行数
     */
    void deleteByUserId(String userId);

    /**
     * 批量保存更新
     *
     * @param userRoleList
     */
    void saveOrUpdateBatchUR(List<GxYyUserRoleRel> userRoleList);


}

