package cn.gtmap.hlw.core.dao.user;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.login.LoginParamsDTO;
import cn.gtmap.hlw.core.dto.user.user.UserQueryParamsDTO;
import cn.gtmap.hlw.core.dto.user.user.UserSaveParamsDTO;
import cn.gtmap.hlw.core.dto.user.user.UserUpdateParamsDTO;
import cn.gtmap.hlw.core.model.GxYyUser;

import java.util.List;

/**
 * 不动产用户表(GxYyUser)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:30
 */
public interface GxYyUserDao {
    /**
     * 查询
     *
     * @param paramsVO
     * @return
     */
    GxYyUser getUserByQueryParams(LoginParamsDTO paramsVO);

    /**
     * 根据id集合查询
     *
     * @param useidList
     * @return:List<GxYyUserPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyUser> listByIds(List<String> useidList);

    /**
     * 根据userId和realName查询
     *
     * @param userIdList
     * @param realName
     * @return
     */
    List<GxYyUser> getByUserIdAndRealName(List<String> userIdList, String realName);

    /**
     * @param queryStr
     * @return List<GxYyUserPO>
     * @description 用户查询
     * @version 2.0, 2024/2/19 14:47
     * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
     */
    List<GxYyUser> listByQueryStr(String queryStr);

    /**
     * 查询所有
     *
     * @return
     */
    List<GxYyUser> listAll();

    List<GxYyUser> listAllSimple();

    /**
     * 删除
     *
     * @param userId
     * @return void
     */
    void delete(String userId);

    /**
     * 启用禁用
     *
     * @param userSaveParamsDTO
     * @return void
     */
    void updateValidAndReason(UserSaveParamsDTO userSaveParamsDTO);

    /**
     * 是否黑名单
     *
     * @param userUpdateParamsDTO
     * @return void
     */
    void updateIsHmd(UserUpdateParamsDTO userUpdateParamsDTO);

    /**
     * 更新密码
     *
     * @param userGuid
     * @param password
     */
    void updatePassword(String userGuid, String password);

    /**
     * 新增修改
     *
     * @param gxYyUser
     * @return String
     */
    String saveOrUpdateUser(GxYyUser gxYyUser);

    /**
     * 通过ID查询单条数据
     *
     * @param userId 主键
     * @return 实例对象
     */
    GxYyUser get(String userId);

    /**
     * 通过证件id查询单条数据
     *
     * @param userZjid 证件id
     * @return 实例对象
     */
    GxYyUser getByUserZjid(String userZjid);

    /**
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据用户名获取用户信息
     */
    GxYyUser getByUserUserName(String userName);

    GxYyUser getByUserLxdh(String userLxdh);

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return GxYyMenuPO集合
     */
    PageInfo<GxYyUser> queryPage(UserQueryParamsDTO paramsDTO);
}

