package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author jianglin
 * @Date 2024/6/27
 * @Description 接口出入参-加解密-工具类
 */
@Slf4j
public class ApiSecurityUtils {

    /**
     * @param sm4KeyBySm2 经过Sm2加密的sm4key
     * @param decryptStr  经过sm4加密的数据
     * @return 解密后的数据
     */
    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    /**
     * @param encryptStr     要加密的数据
     * @param frontPublicKey 前端公钥
     * @return 加密后的数据
     */
    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey)  {
        //生成一个随机的sm4加密key
        String sm4Key = null;
        try {
            sm4Key = Sm4Util.generateKey();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        //加密
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        //用前端公钥(用前端的公钥)，sm2加密sm4Key
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    //加解密测试
    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";

        //前端入参 解密
        String dataEncrypt = "fb4cfa69dfa0e3175fdb7ae3d15a670a68693d7b78d02273ab708860da8152a5a1dd8775f2b0dd162ee8dacf9626dec299bdecb2970748d64cf7c6cf05b81309";
        String paramid = "04186c67b511096b948b7a800e3c3b71bff92e537c19d35b2b946237a7fff3687de6b6521ef64ea0f8f8c0ad9d4980cc8f12640f1aae31bba34ae5d2a28474aa04eb82afb6feaa79dc6fdd4c5a276466a0eae512f62546f5ee91040c030f5437a13c7674e8814812a33ccecd7aebbab71d015e0239d56fcaba0b0e61d0e134d90038bda7691344fe79cda1cb50";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);

        /*//生成前端加密密文
        //生成一个随机的sm4加密key
        String sm4Key = "B13356B451572BFC3478AC20F0E3E163";
        //前端入参
        String encryptStr = "{\"slbh\": \"Y20250924111829936\"}";
        //加密
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        String paramid2 = Sm2lib.encode(sm4Key);

        ApiEncryptBody body = new ApiEncryptBody();
        body.setData(data);
        body.setParamid(paramid2);
        body.setFrontKey(pubKey);

        System.out.println(JSON.toJSONString(body));*/
    }

}
