package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyUnitSqxx;
import cn.gtmap.hlw.core.model.query.sqxx.GxYyUnitSqxxQuery;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;

/**
 * 单位申请信息表(GxYyUnitSqxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:51
 */
public interface GxYyUnitSqxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyUnitSqxx get(String id);

    /**
     * 通过用户id和部门名称查询集合
     *
     * @param userid 用户id
     * @param orgName 部门名称
     * @return 实例对象
     */
    List<GxYyUnitSqxx> getByUseridAndOrgName(String userid, String orgName);

    /**
     * 新增数据
     *
     * @param gxYyUnitSqxx 实例对象
     * @return 影响行数
     */
    void save(GxYyUnitSqxx gxYyUnitSqxx);

    /**
     * 保存或更新
     *
     * @param gxYyUnitSqxx 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYyUnitSqxx gxYyUnitSqxx);

    /**
     * 修改数据
     *
     * @param gxYyUnitSqxx 实例对象
     * @return 影响行数
     */
    void update(GxYyUnitSqxx gxYyUnitSqxx);

    /**
     * 破产管理部门申请查询
     *
     * @param gxYyUnitSqxxQuery 主键
     * @return 实例对象
     */
    IPage<GxYyUnitSqxx> queryUnitApplyByPage(GxYyUnitSqxxQuery gxYyUnitSqxxQuery);


}

