package cn.gtmap.hlw.core.dto.zwfw;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import lombok.Data;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2025/8/7
 * @description 申报基本信息
 */
@Data
@XStreamAlias("SERVICEINFO")
@XmlAccessorType(XmlAccessType.FIELD)
public class ApasInfoServiceInfoDTO {

    /**
     *唯一标识
     */
    @XStreamAlias("UNID")
    private String unid;
    /**
     *办件编号
     */
    @XStreamAlias("PROJID")
    private String projid;
    /**
     *查询密码
     */
    @XStreamAlias("PROJPWD")
    private String projpwd;
    /**
     *事项编码
     */
    @ZdDzConfig(field = "servicecode", tableName = ZdDzConstant.ZD_DZ_SQLX, dmToDm = true)
    @XStreamAlias("SERVICECODE")
    private String servicecode;
    /**
     *事项名称
     */
    @XStreamAlias("SERVICENAME")
    private String servicename;
    /**
     *申报名称
     */
    @XStreamAlias("PROJECTNAME")
    private String projectname;
    /**
     *办件类型编码
     */
    @XStreamAlias("INFOTYPE_CODE")
    private String infotype_code;
    /**
     *是否并联业务
     */
    @XStreamAlias("IS_MULTI")
    private String is_multi;
    /**
     *并联业务标识
     */
    @XStreamAlias("MULTI_ID")
    private String multi_id;
    /**
     *申报者名称
     */
    @XStreamAlias("APPLYNAME")
    private String applyname;
    /**
     *申报者证件类型
     */
    @XStreamAlias("APPLY_CARDTYPE")
    private String apply_cardtype;
    /**
     *申报者证件号码
     */
    @XStreamAlias("APPLY_CARDNUMBER")
    private String apply_cardnumber;
    /**
     *联系人/代理
     */
    @XStreamAlias("CONTACTMAN")
    private String contactman;
    /**
     *联系人/代理人证件类型
     */
    @XStreamAlias("CONTACTMAN_CARDTYPE")
    private String contactman_cardtype;
    /**
     *联系人/代理人证件号码
     */
    @XStreamAlias("CONTACTMAN_CARDNUMBER")
    private String contactman_cardnumber;
    /**
     *联系人手机号码
     */
    @XStreamAlias("TELPHONE")
    private String telphone;
    /**
     *邮编
     */
    @XStreamAlias("POSTCODE")
    private String postcode;
    /**
     *通讯地址
     */
    @XStreamAlias("ADDRESS")
    private String address;
    /**
     *法定代表人
     */
    @XStreamAlias("LEGALMAN")
    private String legalman;
    /**
     *收件部门标识
     */
    @XStreamAlias("DEPTID")
    private String deptid;
    /**
     *收件部门名称
     */
    @XStreamAlias("DEPTNAME")
    private String deptname;
    /**
     *收件人标识
     */
    @XStreamAlias("RECEIVE_USEID")
    private String receive_useid;
    /**
     *收件人名称
     */
    @XStreamAlias("RECEIVE_NAME")
    private String receive_name;
    /**
     *申报来源
     */
    @XStreamAlias("APPLYFROM")
    private String applyfrom;
    /**
     *事项类型
     */
    @XStreamAlias("ADDTYPE")
    private String addtype;
    /**
     *项目编号
     */
    @XStreamAlias("BELONGTO")
    private String belongto;
    /**
     *所属地区编码
     */
    @XStreamAlias("AREACODE")
    private String areacode;
    /**
     *所属单位
     */
    @XStreamAlias("BELONGSYSTEM")
    private String belongsystem;
    /**
     *系统标识
     */
    @XStreamAlias("SOURCE")
    private String source;
    /**
     *反馈类型
     */
    @XStreamAlias("FEEDBACK_TYPE")
    private String feedback_type;
    /**
     *用户帐号名
     */
    @XStreamAlias("CREATE_USER_CODE")
    private String create_user_code;
    /**
     *排队序号
     */
    @XStreamAlias("QUEUENUMBER")
    private String queuenumber;
    /**
     *取号网点编号
     */
    @XStreamAlias("WEBSITEID")
    private String websiteid;
    /**
     * 事项配置渠道
     */
    @XStreamAlias("IS_HUB")
    private String is_hub;
}
