package cn.gtmap.hlw.core.dto.menu.menu;

import cn.gtmap.hlw.core.base.BasePage;
import cn.gtmap.hlw.core.dto.menu.authority.BankMenuDTO;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/13 10:32
 * @description MenuQueryParamsDTO
 */
@Data
public class MenuQueryParamsDTO extends BasePage {
    /**id*/
    private String id;
    /**功能菜单ID*/
    private String functionMenuId;
    /**
     * 功能菜单ID集合
     */
    private List<String> functionMenuIdList;

    /**客户端类型(1为微信，2为web,3为APP，4为其他)*/
    private String clientType;

    /**是否常用（0：是，1：否）*/
    private String isCommon;

    /**区域类型（0:顶部头，1：上边栏，2：左侧边栏，3：更多）*/
    private String areaType;

    /**功能名称*/
    private String name;

    /**菜单所属角色*/
    private String roleId;
    /**菜单类型*/
    private String cdlx;
    /**
     * 申请类型
     */
    private String sqlxId;

    /**是否新一窗**/
    private String sfxyc;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 步骤类型
     */
    private String type;
    /**
     * 银行授权菜单
     */
    List<BankMenuDTO> bankMenuList;
    /**
     * 授权用户
     */
    List<String> userIdList;
    /**
     * 复核申请类型
     */
    private List<String> fhSqlxdmList;
}
