package cn.gtmap.hlw.coredk.utils;

import cn.gtmap.hlw.core.constant.Constants;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.util.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.MDC;

import javax.net.ssl.SSLContext;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;

/**
 * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
 * @version 1.0 2025/7/17
 * @description
 */
@Slf4j
public class DzkfHttpUtil {
    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param
     * @return
     * @description  参考HttpUtil.dopost方法，添加https证书信任
     */
    public static  String doHttpsPost(String apiUrl, String apiName, String json, Map<String, String> headerMap) {
        long start = System.currentTimeMillis();

        SSLContext sslContext = null;
        try {
            //使用 loadTrustMaterial() 方法实现一个信任策略，信任所有证书
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy() {
                // 信任所有
                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        } catch (KeyManagementException e) {
            throw new RuntimeException(e);
        } catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, NoopHostnameVerifier.INSTANCE);
        //创建http实例
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        int statusCode = -999;
        try {
            if (StringUtils.isNotBlank(json)) {
                StringEntity stringEntity = new StringEntity(json, HttpUtil.CHARSET);
                //stringEntity.setContentEncoding(CHARSET);
                stringEntity.setContentType("application/json");
                httpPost.setEntity(stringEntity);
            }
            if (headerMap != null) {
                Iterator headerIterator = headerMap.entrySet().iterator();
                while (headerIterator.hasNext()) {
                    Map.Entry<String, String> elem = (Map.Entry<String, String>) headerIterator.next();
                    httpPost.addHeader(elem.getKey(), elem.getValue());
                }
            }


            response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();
            statusCode = response.getStatusLine().getStatusCode();
            httpStr = EntityUtils.toString(entity, HttpUtil.CHARSET);
        } catch (Exception ex) {
            long end = System.currentTimeMillis() - start;
            MDC.put(Constants.STR_EXECUTETIME, String.valueOf(end));
            MDC.put(Constants.STR_APINAME, apiName);
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
        } finally {
            if (response != null) {
                try {
                    EntityUtils.consume(response.getEntity());
                } catch (IOException ex) {
                    log.error("HttpUtil doPost error:" + ex.getMessage());
                }
            }
            long end = System.currentTimeMillis() - start;
            MDC.put(Constants.STR_EXECUTETIME, String.valueOf(end));
            MDC.put(Constants.STR_APINAME, apiName);
            if (!StringUtils.equals(apiName, "es查询")) {
                if (apiUrl.contains("wwsq/tsWwsqFjxx") || apiUrl.contains("storages/multipart/upload")) {
                    log.info("request to:{},param.length:{},response code:{},cost {} ms", new Object[]{apiUrl, json.length(), statusCode, end});
                } else {
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, json, statusCode, end});
                }
                if (apiUrl.contains("zzgx/zzxxxz")) {
                    log.info("result to {} : 出参过滤 {}", apiUrl, httpStr.length());
                } else {
                    log.info("result:{}", new Object[]{httpStr});
                }
            }
        }
        return httpStr;
    }


    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param
     * @return
     * @description  参考HttpUtil.doGet方法，添加https证书信任
     */
    public static String doHttpsGet(String url, String apiName, Map<String, Object> params, Map<String, String> headerMap) {
        long start = System.currentTimeMillis();

        SSLContext sslContext = null;
        try {
            //使用 loadTrustMaterial() 方法实现一个信任策略，信任所有证书
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy() {
                // 信任所有
                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        } catch (KeyManagementException e) {
            throw new RuntimeException(e);
        } catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, NoopHostnameVerifier.INSTANCE);
        //创建http实例
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(sslsf).build();


        StringBuffer param = new StringBuffer();
        int i = 0;

        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                // 拼接参数
                if (i == 0) {
                    param.append("?");
                } else {
                    param.append("&");
                }
                i = i + 1;
                param.append(key).append("=").append(params.get(key));
            }
        }

        String apiUrl = url + param;
        String result = null;
        int statusCode = -999;
        try {
            HttpGet httpGet = new HttpGet(apiUrl);
            //循环增加header
            if (headerMap != null) {
                Iterator headerIterator = headerMap.entrySet().iterator();
                while (headerIterator.hasNext()) {
                    Map.Entry<String, String> elem = (Map.Entry<String, String>) headerIterator.next();
                    httpGet.addHeader(elem.getKey(), elem.getValue());
                }
            }
            HttpResponse response = httpClient.execute(httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString(entity, HttpUtil.CHARSET);
        } catch (Exception ex) {
            long end = System.currentTimeMillis() - start;
            MDC.put(Constants.STR_EXECUTETIME, String.valueOf(end));
            MDC.put(Constants.STR_APINAME, apiName);
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
        } finally {
            if (httpClient != null) {
                HttpClientUtils.closeQuietly(httpClient);
            }
            long end = System.currentTimeMillis() - start;
            MDC.put(Constants.STR_EXECUTETIME, String.valueOf(end));
            MDC.put(Constants.STR_APINAME, apiName);
            log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(param), statusCode, end});
            log.info("result:{}", new Object[]{result});
        }
        return result;
    }

}
